<?php

class ExportPdfForm extends FormModel {

    public $viewer_password;
    public $admin_password;
    public $title;
    public $varPreview;
    public $varData;

    public function rules() {
        return $this->getRulesArray();
    }

    public function myAttributeLabels() {
        return array(
            'viewer_password' => Yii::t('app', 'Viewer password'),
            'admin_password' => Yii::t('app', 'Admin password'),
            'title' => Yii::t('app', 'Title'),
        );
    }

    private function getRulesArray() {
        $rulesArray = array(
            array('title, varPreview, varData', 'required'),
        );
        switch (Yii::app()->params['pdfPassword']) {
            case 'all':
            default:
                $rulesArray[] = array('viewer_password, admin_password', 'required');
                break;
            case 'admin':
                $rulesArray[] = array('admin_password', 'required');
                break;
            case 'view':
                $rulesArray[] = array('viewer_password', 'required');
                break;
            case 'none':
                //do nothing
                break;
        }
        return $rulesArray;
    }

}
