<?php

/**
 * This is the model class for table "special_day".
 *
 * The followings are the available columns in table 'special_day':
 * @property integer $id
 * @property string $name
 * @property string $description
 * @property integer $day
 * @property integer $month
 * @property string $epoch
 */
class SpecialDay extends ActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SpecialDay the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'special_day';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('day, month', 'numerical', 'integerOnly'=>true),
			array('name', 'length', 'max'=>255),
			array('description, epoch', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('name, day, month', 'required'),
			array('name', 'unique'),
			array('day+month', 'application.extensions.uniqueMultiColumnValidator', 'message'=>t('Date already present!')),
			array('id, name, description, day, month, epoch', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}
	
	public function behaviors()
	{
		return array('edatetimebehavior' => array('class' => 'ext.EDateTimeBehavior'));
	}
	
	protected function beforeSave()
	{
		if ($this->isNewRecord)
			$this->epoch = new DateTime();
	
		return parent::beforeSave();
	}
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function myAttributeLabels()
	{
		return array(
			'id' => t('ID'),
			'name' => t('Name'),
			'description' => t('Description'),
			'day' => t('Day'),
			'month' => t('Month'),
			'epoch' => t('Epoch'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('name',$this->name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('day',$this->day);
		$criteria->compare('month',$this->month);
		$criteria->compare('epoch',$this->epoch,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}