<?php

class AlertPresenter extends SimpleDelegator {

    private $listName;
    private $alertCategory;
    private $alertNotes;

    static function getProperty($alert, $propertyName) {
        if (is_null($alert))
            return null;

        $presenter = new AlertPresenter($alert);

        return call_user_func(array($presenter, $propertyName));
    }

    public function getLevelIcon() {
        switch ($this->type) {
            case 'alarm':
                $icon = '<i class="icon-exclamation alarm-icon"></i>';
                break;
            case 'warning':
                $icon = '<i class="icon-warning-sign warning-icon"></i>';
                break;
            default:
                $icon = '<i class="icon-info-sign info-icon"></i>';
                break;
        }
        return $icon;
    }

    public function getVehicleSpeed() {
        $speed = $this->associatedEvent->vehicleSpeed;
        if ($speed < 0)
            return "-";
        else
            return sprintf("%.2f", $speed);
    }

    public function getVehicleKemler() {
        return $this->associatedEvent->Kemler;
    }

    public function getVehicleKemlerDescription() {
        if ($this->hasAssociatedEvent()) {
            $kemlerCode = $this->associatedEvent->Kemler;
            $adrDescription = $this->getAdrDescription($kemlerCode);
            $onuDescription = $this->getOnuDescription($kemlerCode);
            if (isset($adrDescription) && isset($onuDescription))
                return "{$adrDescription} - {$onuDescription}";
        }
    }

    public function getPlate() {
        $plate = $this->associatedEvent->Plate;
        if (empty($plate))
            $plate = "-----";

        if (strlen($plate) > 8)
            return substr($plate, 0, 6) . "..";
        else
            return $plate;
    }

    public function getNationalityCode() {
        return $this->associatedEvent->nationalityCode;
    }

    public function getVehicleClassIcon() {
        $vehicle_class = $this->associatedEvent->vehicleClass;
        if ($vehicle_class == null)
            return null;

        return strtolower($vehicle_class . ".png");
    }

    public function getAlertDateTime() {
        if ($this->hasAssociatedEvent()) {
            return $this->associatedEvent->eventDateTime;
        }

        return $this->epoch;
    }

    private function getAdrDescription($kemlerCode) {
        $kemler = new Kemler($kemlerCode);
        $adr = $kemler->adr;
        if (isset($adr))
            return $adr->description;
    }

    private function getOnuDescription($kemlerCode) {
        $kemler = new Kemler($kemlerCode);
        $onu = $kemler->onu;
        if (isset($onu))
            return $onu->description;
    }

    public function getBlacklistVehicleMatches() {
        if ($this->isBlacklist()) {
            if (strlen($this->extra_data) <= 0)
                return null;

            $vehicleIDs = explode(';', $this->extra_data);
            if (sizeof($vehicleIDs) <= 0)
                return null;

            return $vehicleIDs;
        }

        return null;
    }

    public function getBlacklistCategories() {
        $vehicleIDs = $this->blacklistVehicleMatches;

        if (empty($vehicleIDs))
            return null;

        $categories = Vehicle::getGategoryList($vehicleIDs);
        return $categories;
    }

    public function getBackGroundColor() {
        if ($this->isBlacklist()) {
            if (strlen($this->extra_data) <= 0)
                return null;

            $vehicleIDs = explode(';', $this->extra_data);
            if (sizeof($vehicleIDs) <= 0)
                return null;

            $categories = Vehicle::getGategoryList($vehicleIDs);
            return VehicleCategory::getBestColorForCategories($categories);
        }

        return null;
    }

    public function getHtmlEventDescription() {
        $descr = t($this->description);

        if ($this->event_note)
            $descr .= "-";

        if ($this->isBlacklist())
            $descr .= '<i class = "icon-align-justify"></i>';
        else if ($this->isTrafficAlarm())
            $descr .= '<i class = "icon-road"></i>';

        $descr .= t($this->event_note);

        return $descr;
    }

    public function getComment() {
        if (property_exists($this->associatedEvent, "validation_result") && $this->associatedEvent->validation_result == "invalid") {
            return $this->associatedEvent->TransitComments;
        }
        return '';
    }

    public function getAlertCategory() {
        if (is_null($this->alertCategory)) {
            $this->updateVehicleInfo();
        }
        return $this->alertCategory;
    }

    function getListName() {
        if (is_null($this->alertCategory)) {
            $this->updateVehicleInfo();
        }
        return $this->listName;
    }

    function getAlertNotes() {
        if (is_null($this->alertCategory)) {
            $this->updateVehicleInfo();
        }
        return $this->alertNotes;
    }

    public function updateVehicleInfo() {
        if (!is_null($this->extra_data)) {
            $associatedVehicle = Vehicle::model()->findByPk($this->extra_data);
            if (!is_null($associatedVehicle)) {
                $this->alertCategory = $associatedVehicle->category;
                $wl= PlateAuthorization::model()->byVehicleId($this->extra_data)->find();
                if(!is_null($wl)){
                    $this->alertNotes = $wl->Note;
                }
                $this->listName = $associatedVehicle->getListName();
            }
        }
        $this->alertCategory = empty($this->alertCategory)  ? "N/A" : $this->alertCategory;
        $this->alertNotes = empty($this->alertNotes) ? "N/A" : $this->alertNotes;
        $this->listName = empty($this->listName) ? "N/A" : $this->listName;
    }

}
