<h2><?php echo htmlspecialchars(t('Export list details',array(),'exportReport'),ENT_QUOTES,'UTF-8'); ?></h2>
<table class="reporttable table table-striped">
  <thead>
    <tr>
      <th><?php echo htmlspecialchars(t('Date'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Time'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('User'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Exported',array(),'exportReport'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('First code',array(),'exportReport'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Last code',array(),'exportReport'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Deleted',array(),'exportReport') ,ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php $counter = 0; ?>
    <?php foreach($exportedEvents as $expEvent) { ?>
      <tr <?php echo MtHaml\Runtime::renderAttributes(array(array('class', $breakClass)), 'html5', 'UTF-8'); ?>>
        <td><?php echo htmlspecialchars(DateHelper::formatISO9075Date($expEvent->export_time),ENT_QUOTES,'UTF-8'); ?></td>
        <td><?php echo htmlspecialchars(DateHelper::formatISO9075Time($expEvent->export_time),ENT_QUOTES,'UTF-8'); ?></td>
        <td><?php echo htmlspecialchars($expEvent->user_name,ENT_QUOTES,'UTF-8'); ?></td>
        <td><?php echo htmlspecialchars($expEvent->gate_sn,ENT_QUOTES,'UTF-8'); ?></td>
        <td><?php echo htmlspecialchars($expEvent->exported_events,ENT_QUOTES,'UTF-8'); ?></td>
        <td>
          <?php echo htmlspecialchars(($expEvent->min_ext_code > 0)? $expEvent->min_ext_code: '-',ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars(($expEvent->max_ext_code > 0)? $expEvent->max_ext_code: '-',ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td><?php echo htmlspecialchars($expEvent->deleted_events,ENT_QUOTES,'UTF-8'); ?></td>
      </tr>
    <?php } ?>
  </tbody>
</table>
