<?php $documents = $dataProvider->data; ?>
<?php $freshDocumentTimeout = 300; ?>
<div id="report-archive-page">
  <div class="page-header">
    <h2>Report Archive</h2>
  </div>
  <div class="row form-box">
    <?php $form = $this->beginWidget('bootstrap.widgets.TbActiveForm',            array('id'=>'report-archive-search-form','action' => Yii::app()->createUrl($this->route),)); ?>
    <fieldset>
      <div class="row">
        <div class="span5">
          <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'date-time-range-search'), array('class', 'span'), array('data-behavior', 'DateRangeInput'), array('data-date-range-start-target', ('#search-date-start')), array('data-date-range-end-target', ('#search-date-end'))), 'html5', 'UTF-8'); ?>>
            <label><?php echo htmlspecialchars(t("Date/Time"),ENT_QUOTES,'UTF-8'); ?></label>
            <div class="date-time-range-block span" style="margin-left:0">
              <?php echo htmlspecialchars(t("From"),ENT_QUOTES,'UTF-8'); ?>
              <div id="search-date-start" class="input-append date datetime-picker">
                <input <?php echo MtHaml\Runtime::renderAttributes(array(array('data-format', (Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'ReportArchiveSearchForm[startDateTime]'), array('value', ($reportArchiveSearchForm->startDateTime))), 'html5', 'UTF-8'); ?>>
                  <span class="add-on">
                    <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                  </span>
                </input>
              </div>
            </div>
            <div class="date-time-range-block span">
              <?php echo htmlspecialchars(t("To")      ,ENT_QUOTES,'UTF-8'); ?>
              <div id="search-date-end" class="input-append date datetime-picker">
                <input <?php echo MtHaml\Runtime::renderAttributes(array(array('data-format', (Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'ReportArchiveSearchForm[endDateTime]'), array('value', ($reportArchiveSearchForm->endDateTime))), 'html5', 'UTF-8'); ?>>
                  <span class="add-on">
                    <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                  </span>
                </input>
              </div>
            </div>
          </div>
        </div>
        <div class="span5">
          <label><?php echo htmlspecialchars(t("Gate Group"),ENT_QUOTES,'UTF-8'); ?></label>
          <select <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'report-archive-gategroup-filter'), array('class', ('selectpicker' . ' ' . 'span3')), array('multiple', 'multiple'), array('data-live-search', 'false'), array('title', (t('Select Gate Group...'))), array('name', 'ReportArchiveSearchForm[gateGroups][]')), 'html5', 'UTF-8'); ?>>
            <?php foreach($gateGroups as $gateGroup) { ?>
              <?php if (isset($reportArchiveSearchForm->gateGroups) && in_array($gateGroup['ID'], $reportArchiveSearchForm->gateGroups)) { ?>
                <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($gateGroup->ID)), array('selected', 'selected')), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($gateGroup->name,ENT_QUOTES,'UTF-8'); ?>
                </option>
              <?php } else { ?>
                <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($gateGroup->ID))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($gateGroup->name,ENT_QUOTES,'UTF-8'); ?>
                </option>
              <?php } ?>
            <?php } ?>
          </select>
        </div>
      </div>
      <div class="row" style="margin-top:10px;">
        <div class="span5">
          <div style="margin-left:30px">
            <label><?php echo htmlspecialchars(t("ADI Code"),ENT_QUOTES,'UTF-8'); ?></label>
            <div class="span" style="margin-left:0">
              <?php echo htmlspecialchars(t("From"),ENT_QUOTES,'UTF-8'); ?>
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('style', 'width:70%'), array('name', 'ReportArchiveSearchForm[ADIcodeFrom]'), array('value', ($reportArchiveSearchForm->ADIcodeFrom))), 'html5', 'UTF-8'); ?> />
            </div>
            <div class="span" style="margin-left:0">
              <?php echo htmlspecialchars(t("To"),ENT_QUOTES,'UTF-8'); ?>
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('style', 'width:73%'), array('name', 'ReportArchiveSearchForm[ADIcodeTo]'), array('value', ($reportArchiveSearchForm->ADIcodeTo))), 'html5', 'UTF-8'); ?> />
            </div>
          </div>
        </div>
        <?php if(user()->checkAccess('report_archive_view_all'))  { ?>
          <div class="span5">
            <label><?php echo htmlspecialchars(t("Users"),ENT_QUOTES,'UTF-8'); ?></label>
            <select <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'report-archive-users-filter'), array('class', ('selectpicker' . ' ' . 'span3')), array('multiple', 'multiple'), array('data-live-search', 'false'), array('title', (t('Select Users...'))), array('name', 'ReportArchiveSearchForm[users][]')), 'html5', 'UTF-8'); ?>>
              <?php foreach($users as $user) { ?>
                <?php if (isset($reportArchiveSearchForm->users) && in_array($user['id'], $reportArchiveSearchForm->users)) { ?>
                  <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($user->id)), array('selected', 'selected')), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($user->username,ENT_QUOTES,'UTF-8'); ?>
                  </option>
                <?php } else { ?>
                  <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($user->id))), 'html5', 'UTF-8'); ?>>
                    <?php echo htmlspecialchars($user->username,ENT_QUOTES,'UTF-8'); ?>
                  </option>
                <?php } ?>
              <?php } ?>
            </select>
          </div>
        <?php } ?>
      </div>
      <div class="row">
        <button id="search-for-report-archive" class="pull-right btn" type="submit">
          <?php echo htmlspecialchars(t("Filter"),ENT_QUOTES,'UTF-8'); ?>
        </button>
      </div>
    </fieldset>
    <?php $this->endWidget(); ?>
  </div>
  <div class="row">
    <?php if (isset($dataProvider) && count($dataProvider->data)>0) { ?>
      <div class="report-table-container" style="margin-top:10px">
        <table class="table table-striped table-condensed">
          <thead>
            <tr>
              <td><?php echo htmlspecialchars(t('User'),ENT_QUOTES,'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars(t('Date'),ENT_QUOTES,'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars(t('Time'),ENT_QUOTES,'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars(t('Session'),ENT_QUOTES,'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars(t('Service'),ENT_QUOTES,'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars(t('Gate Group'),ENT_QUOTES,'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars(t('ADI Code From'),ENT_QUOTES,'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars(t('ADI Code To'),ENT_QUOTES,'UTF-8'); ?></td>
              <td><?php echo htmlspecialchars(t('Report'),ENT_QUOTES,'UTF-8'); ?></td>
            </tr>
          </thead>
          <tbody>
            <?php $now = new DateTime(); ?>
            <?php foreach($documents as $document) { ?>
              <?php $freshDocumentBtnClass = ""; ?>
              <?php if ( ($now->getTimestamp() - $document->CreationTime->getTimestamp()) < $freshDocumentTimeout ) { ?>
                <?php $freshDocumentBtnClass = "btn-info"; ?>
              <?php } ?>
              <tr>
                <td><?php echo htmlspecialchars($document->user->username,ENT_QUOTES,'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars(DateHelper::formatLocalDate($document->CreationTime),ENT_QUOTES,'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars(DateHelper::formatISO9075Time($document->CreationTime),ENT_QUOTES,'UTF-8'); ?></td>
                <?php if(empty($document->PeriodID)) { ?>
                  <td><?php echo htmlspecialchars("-",ENT_QUOTES,'UTF-8'); ?></td>
                <?php } else { ?>
                  <td><?php echo htmlspecialchars($document->PeriodID,ENT_QUOTES,'UTF-8'); ?></td>
                <?php } ?>
                <?php if(empty($document->serviceID)) { ?>
                  <td><?php echo htmlspecialchars("-",ENT_QUOTES,'UTF-8'); ?></td>
                <?php } else { ?>
                  <td><?php echo htmlspecialchars($document->serviceID,ENT_QUOTES,'UTF-8'); ?></td>
                <?php } ?>
                <td><?php echo htmlspecialchars($document->gateGroup->name                   ,ENT_QUOTES,'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($document->MinExtcode,ENT_QUOTES,'UTF-8'); ?></td>
                <td><?php echo htmlspecialchars($document->MaxExtcode,ENT_QUOTES,'UTF-8'); ?></td>
                <td>
                  <?php if(user()->checkAccess('report_archive_view_report')) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-small')), array('class', $freshDocumentBtnClass), array('href', (Yii::app()->createAbsoluteUrl('reportArchive/showReport', array('reportID' => $document->ID)))), array('target', ('_blank'))), 'html5', 'UTF-8'); ?>>
                      <?php echo htmlspecialchars(t("View"),ENT_QUOTES,'UTF-8'); ?>
                    </a>
                  <?php } ?>
                </td>
              </tr>
            <?php } ?>
          </tbody>
        </table>
      </div>
      <div class="pagination">
        <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $dataProvider->pagination)); ?>
      </div>
    <?php } else { ?>
      <h4><?php echo htmlspecialchars(Yii::t("app", "No results"),ENT_QUOTES,'UTF-8'); ?></h4>
    <?php } ?>
  </div>
</div>
