<div id="street-patrol-page">
  <div class="page-header">
    <h2><?php echo htmlspecialchars(t('Street Patrol'),ENT_QUOTES,'UTF-8'); ?></h2>
  </div>
  <div class="row">
    <div class="form-box">
      <div class="span3">
        <div class="btn-group">
          <button id="street-patrol-start-btn" class="btn"><?php echo htmlspecialchars(t('Start Session'),ENT_QUOTES,'UTF-8'); ?></button>
          <button id="street-patrol-stop-btn" class="btn"><?php echo htmlspecialchars(t('Stop Session'),ENT_QUOTES,'UTF-8'); ?></button>
        </div>
      </div>
      <div class="span5">
        <b><?php echo htmlspecialchars(t('Display Timeout'),ENT_QUOTES,'UTF-8'); ?></b>
        <?php echo CHtml::dropDownList('street-patrol-events-timeout', 0, array(0=>t('Disabled'), 30000=>t('30 Seconds'), 60000=>t('1 Minute'), 120000=>t('2 Minutes')));; ?>
      </div>
      <div class="span3">
        <div class="btn-group">
          <button id="street-patrol-review-session-btn" class="btn"><?php echo htmlspecialchars(t('Review Session'),ENT_QUOTES,'UTF-8'); ?></button>
          <button id="street-patrol-delete-session-btn" class="btn"><?php echo htmlspecialchars(t('Delete Session'),ENT_QUOTES,'UTF-8'); ?></button>
        </div>
      </div>
    </div>
  </div>
  <div class="row">
    <div <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'tableContainer'), array('id', 'street-patrol-events-container'), array('data-behavior', ('StreetPatrol'))), 'html5', 'UTF-8'); ?>>
      <table id="street-patrol-events-table" class="table table-condensed span12">
        <thead>
          <tr>
            <th><?php echo htmlspecialchars(t('Handled on Site'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Plate'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Image'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Revision'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Insurance'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Date Time'),ENT_QUOTES,'UTF-8'); ?></th>
          </tr>
        </thead>
        <tbody></tbody>
      </table>
    </div>
    <div id="street-patrol-no-events-message"><?php echo htmlspecialchars(t('no events to show'),ENT_QUOTES,'UTF-8'); ?></div>
  </div>
</div>
