<script type="text/javascript" src="../js/reportDownloader.js"></script>
<div id="stats-events-management-page">
  <div class="page-header">
    <h2>
      <i class="icon-bar-chart"></i>
      <?php echo htmlspecialchars(Yii::t("app", "Stats"),ENT_QUOTES,'UTF-8'); ?>
    </h2>
  </div>
  <form <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'form-box'), array('id', 'events-management-search-form'), array('method', 'post'), array('action', (Yii::app()->createUrl($this->route)))), 'html5', 'UTF-8'); ?>>
    <div class="row">
      <div class="span8">
        <div class="controls">
          <h4>
            <i class="icon-time"></i>
            <?php echo htmlspecialchars(t('When'),ENT_QUOTES,'UTF-8'); ?>
            <small><?php echo htmlspecialchars(t('Choose a date range'),ENT_QUOTES,'UTF-8'); ?></small>
          </h4>
        </div>
        <div class="controls">
          <div <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'date-time-range-search'), array('data-behavior', 'DateRangeInput'), array('data-date-range-start-target', ('#search-date-start')), array('data-date-range-end-target', ('#search-date-end'))), 'html5', 'UTF-8'); ?>>
            <div id="search-date-start" class="input-prepend input-append date datetime-picker">
              <span class="add-on"><?php echo htmlspecialchars(t('From'),ENT_QUOTES,'UTF-8'); ?></span>
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('data-format', (Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'EventsStatisticsSearchForm[startDateTime]'), array('value', ($eventsStatisticsSearchForm->startDateTime))), 'html5', 'UTF-8'); ?>>
                <span class="add-on">
                  <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                </span>
              </input>
            </div>
            <div id="search-date-end" class="input-prepend input-append date datetime-picker">
              <span class="add-on"><?php echo htmlspecialchars(t('To'),ENT_QUOTES,'UTF-8'); ?></span>
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('data-format', (Yii::app()->params['datetimeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'EventsStatisticsSearchForm[endDateTime]'), array('value', ($eventsStatisticsSearchForm->endDateTime))), 'html5', 'UTF-8'); ?>>
                <span class="add-on">
                  <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
                </span>
              </input>
            </div>
            <span><?php echo htmlspecialchars(t('Time Slot'),ENT_QUOTES,'UTF-8'); ?></span>
            <div id="datepicker-start-time" class="input-prepend input-append time-picker">
              <span class="add-on"><?php echo htmlspecialchars(t('From'),ENT_QUOTES,'UTF-8'); ?></span>
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'EventsStatisticsSearchForm[startTimeSlot]'), array('value', ($eventsStatisticsSearchForm->startTimeSlot))), 'html5', 'UTF-8'); ?> />
              <span class="add-on">
                <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
              </span>
            </div>
            <div id="datepicker-end-time" class="input-prepend input-append time-picker">
              <span class="add-on"><?php echo htmlspecialchars(t('To'),ENT_QUOTES,'UTF-8'); ?></span>
              <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'span1'), array('data-format', (Yii::app()->params['timeselect_format'][Yii::app()->language]['view'])), array('type', 'text'), array('name', 'EventsStatisticsSearchForm[endTimeSlot]'), array('value', ($eventsStatisticsSearchForm->endTimeSlot))), 'html5', 'UTF-8'); ?> />
              <span class="add-on">
                <i data-time-icon="icon-time" data-date-icon="icon-calendar"></i>
              </span>
            </div>
          </div>
        </div>
        <div class="controls search-options">
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DatePickSetter')), array('data-datepick-setter-mode', ('datetime')), array('data-datepick-setter-range', ('7')), array('data-datepick-setter-start-target', '#search-date-start'), array('data-datepick-setter-end-target', '#search-date-end'), array('value', (t('Last 7 days')))), 'html5', 'UTF-8'); ?> />
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DatePickSetter')), array('data-datepick-setter-mode', ('datetime')), array('data-datepick-setter-range', ('30')), array('data-datepick-setter-start-target', '#search-date-start'), array('data-datepick-setter-end-target', '#search-date-end'), array('value', (t('Last 30 days')))), 'html5', 'UTF-8'); ?> />
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('button')), array('data-behavior', ('DatePickSetter')), array('data-datepick-setter-mode', ('datetime')), array('data-datepick-setter-range', ('60')), array('data-datepick-setter-start-target', '#search-date-start'), array('data-datepick-setter-end-target', '#search-date-end'), array('value', (t('Last 60 days')))), 'html5', 'UTF-8'); ?> />
        </div>
        <div class="controls submit-actions">
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('type', ('submit')), array('value', (t('Search')))), 'html5', 'UTF-8'); ?> />
          <a class="btn print-btn" href="#" data-toggle="tooltip">
            <?php echo htmlspecialchars(t('Print'),ENT_QUOTES,'UTF-8'); ?>
          </a>
          <input <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('id', 'events-management-export-violations'), array('type', 'button'), array('onclick', ('exportViolationReport(\'' . (t('Approved Violations')) . '\',\'' . (t('Invalid Violations')) . '\',\'' . (t('Exported Violations')) . '\',\'' . (t('Total Violations')) . '\',\'' . (t('Pending Violations')) . '\',\'' . (t('Violations Management')) . '\',\'' . (t('byDate')) . '\',\'' . (t('byGate')) . '\',\'' . (t('byExport')) . '\')')), array('value', (t('Export')))), 'html5', 'UTF-8'); ?> />
        </div>
      </div>
      <div class="span3">
        <div class="controls">
          <h4>
            <i class="icon-map-marker"></i>
            <?php echo htmlspecialchars(t('Where'),ENT_QUOTES,'UTF-8'); ?>
            <small><?php echo htmlspecialchars(t('Gates'),ENT_QUOTES,'UTF-8'); ?></small>
          </h4>
          <select <?php echo MtHaml\Runtime::renderAttributes(array(array('id', 'stats-events-management-gate-filter'), array('class', ('selectpicker' . ' ' . 'span3')), array('multiple', 'multiple'), array('data-live-search', 'false'), array('title', (t('Select Gate'))), array('name', 'EventsStatisticsSearchForm[gates][]')), 'html5', 'UTF-8'); ?>>
            <?php foreach($gates as $gate) { ?>
              <?php if (isset($eventsStatisticsSearchForm->gates) && in_array($gate['Gate'], $eventsStatisticsSearchForm->gates)) { ?>
                <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($gate->Gate)), array('selected', 'selected')), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
                </option>
              <?php } else { ?>
                <option <?php echo MtHaml\Runtime::renderAttributes(array(array('value', ($gate->Gate))), 'html5', 'UTF-8'); ?>>
                  <?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
                </option>
              <?php } ?>
            <?php } ?>
          </select>
        </div>
      </div>
    </div>
  </form>
  <?php if (isset($validationErrors)) { ?>
    <?php $this->renderPartial('eventsManagement/_formValidationErrors', get_defined_vars()); ?>
  <?php } else if (!is_null($violationsCountByTimespanStatsData)) { ?>
    <?php $this->renderPartial('eventsManagement/_searchResults', get_defined_vars()); ?>
  <?php } ?>
</div>
