<?php if (isset($dataProvider) && count($dataProvider->data)>0) { ?>
  <?php $events = $dataProvider->data; ?>
  <?php $accessReport = Yii::app()->user->checkAccess('show_event_report');; ?>
  <?php $veichleClasses = VehicleTypes::localized(); ?>
  <div class="tableContainer pagination-data-container">
    <table id="results" class="table table-striped table-bordered table-hover span12">
      <thead>
        <tr>
          <th><?php echo htmlspecialchars(Yii::t("app", "License plate"),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(Yii::t("app", "External Code"),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(Yii::t("app", "Date"),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(Yii::t("app", "Time"),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(Yii::t("app", "Gate"),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(Yii::t("app", "Vehicle class"),ENT_QUOTES,'UTF-8'); ?></th>
          <th><?php echo htmlspecialchars(Yii::t("app", "Speed"),ENT_QUOTES,'UTF-8'); ?></th>
          <?php if ($accessReport) { ?>
            <th><?php echo htmlspecialchars(Yii::t("app", "Report"),ENT_QUOTES,'UTF-8'); ?></th>
          <?php } ?>
        </tr>
      </thead>
      <tbody>
        <?php foreach($events as $event) { ?>
          <tr>
            <td>
              <?php if(Yii::app()->user->checkAccess('license_plate_visibility')) { ?>
                <?php echo htmlspecialchars($event->Plate,ENT_QUOTES,'UTF-8'); ?>
              <?php } else { ?>
                <?php echo htmlspecialchars("#######"  ,ENT_QUOTES,'UTF-8'); ?>
              <?php } ?>
            </td>
            <td>
              <?php if ($event->ext_code!='') { ?>
                <div class="btn-group">
                  <a class="btn btn-small dropdown-toggle" data-toggle="dropdown" href="#">
                    <?php echo htmlspecialchars($event->ext_code,ENT_QUOTES,'UTF-8'); ?>
                    <span class="caret"></span>
                  </a>
                  <?php if(Yii::app()->user->checkAccess('show_event_violation_document'))     { ?>
                    <ul class="dropdown-menu pull-right">
                      <?php foreach ($event->eventBehaviors as $index => $eventBehavior) { ?>
                        <?php if($eventBehavior->definitive) { ?>
                          <li>
                            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (Yii::app()->createAbsoluteUrl('event/violationDocumentPreview', array('violationDocumentId' => $eventBehavior->definitive->id)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(t("{$eventBehavior->behavior->name}"),ENT_QUOTES,'UTF-8'); ?></a>
                          </li>
                        <?php } ?>
                      <?php } ?>
                      <?php foreach($event->videos as $index => $video) { ?>
                        <li>
                          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($video->url)), array('target', '_blank')), 'html5', 'UTF-8'); ?>>
                            <i class="icon-play"></i>
                            <?php echo htmlspecialchars(t("Video #vindex", array('vindex'=> ($index+1))),ENT_QUOTES,'UTF-8'); ?>
                          </a>
                        </li>
                      <?php } ?>
                    </ul>
                  <?php } ?>
                </div>
              <?php } ?>
            </td>
            <td><?php echo htmlspecialchars(DateHelper::formatISO9075Date($event->StartTime),ENT_QUOTES,'UTF-8'); ?></td>
            <td><?php echo htmlspecialchars(DateHelper::formatISO9075Time($event->StartTime),ENT_QUOTES,'UTF-8'); ?></td>
            <td><?php echo htmlspecialchars($event->Gate,ENT_QUOTES,'UTF-8'); ?></td>
            <td><?php echo htmlspecialchars($veichleClasses[$event->custom_vehicle_type],ENT_QUOTES,'UTF-8'); ?></td>
            <td>
              <?php if ($event->Speed > 0) { ?>
                <?php echo htmlspecialchars("$event->Speed Km/h",ENT_QUOTES,'UTF-8'); ?>
              <?php } else { ?>
                <?php echo htmlspecialchars("-",ENT_QUOTES,'UTF-8'); ?>
              <?php } ?>
            </td>
            <?php if ($accessReport) { ?>
              <td>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('href', (Yii::app()->createAbsoluteUrl('event/report', array('id' => $event->ID)))), array('target', '_blank')), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t("app", "Generate"),ENT_QUOTES,'UTF-8'); ?></a>
              </td>
              <td>
                <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('btn' . ' ' . 'btn-mini')), array('href', (Yii::app()->createAbsoluteUrl('event/view', array('id' => $event->ID))))), 'html5', 'UTF-8'); ?>><?php echo htmlspecialchars(Yii::t("app", "Export"),ENT_QUOTES,'UTF-8'); ?></a>
              </td>
            <?php } ?>
          </tr>
        <?php } ?>
      </tbody>
    </table>
  </div>
  <?php if (isset($dataProvider->pagination)) { ?>
    <div class="pagination-links-container pagination">
      <?php $this->widget('bootstrap.widgets.TbPager', array('pages' => $dataProvider->pagination)); ?>
    </div>
  <?php } ?>
<?php } else { ?>
  <h4><?php echo htmlspecialchars(Yii::t("app", "No results"),ENT_QUOTES,'UTF-8'); ?></h4>
<?php } ?>
