<td><?php echo $alert->levelIcon; ?></td>
<td>
  <a class="tooltipbox">
    <div class="alert-description">
      <?php echo htmlspecialchars(t($alert->description),ENT_QUOTES,'UTF-8'); ?>
      <?php if($alert->event_note) { ?>
        <?php echo htmlspecialchars("-",ENT_QUOTES,'UTF-8'); ?>
        <?php $this->renderPartial('/shared/_alertNote', array('alert' => $alert))  ; ?>
      <?php } ?>
      <span>
        <p>
          <?php if(isset(Yii::app()->params['eventsToShow']) && Yii::app()->params['eventsToShow']=="alarm") { ?>
            <b>
              <?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?>:
            </b>
            <?php echo htmlspecialchars($alert->getListName(),ENT_QUOTES,'UTF-8'); ?>
            <br />
            <b>
              <?php echo htmlspecialchars(t('Notes'),ENT_QUOTES,'UTF-8'); ?>:
            </b>
            <?php echo htmlspecialchars($alert->getAlertNotes(),ENT_QUOTES,'UTF-8'); ?>
            <br />
            <?php if(isset(Yii::app()->params['eventsToShow']) && Yii::app()->params['eventsToShow']=="alarm") { ?>
              <b>
                <?php echo htmlspecialchars(t('Alert type'),ENT_QUOTES,'UTF-8'); ?>:
              </b>
            <?php } ?>
          <?php } ?>
          <?php $categories = $alert->blacklistCategories; ?>
          <?php if(!empty($categories)) { ?>
            <?php foreach($categories as $cat) { ?>
              <?php echo htmlspecialchars("{$cat} ",ENT_QUOTES,'UTF-8'); ?>
              <br />
            <?php } ?>
          <?php } else { ?>
            <?php if(isset(Yii::app()->params['eventsToShow']) && Yii::app()->params['eventsToShow']=="alarm") { ?>
              N/A
              <br />
            <?php } ?>
          <?php } ?>
          <?php if(!isset(Yii::app()->params['eventsToShow']) || Yii::app()->params['eventsToShow']!=="alarm") { ?>
            <b>
              <?php echo htmlspecialchars(t('Action'),ENT_QUOTES,'UTF-8'); ?>:
            </b>
            <br />
            <?php if(strlen($alert->action) > 0)   { ?>
              <?php echo htmlspecialchars("{$alert->action}",ENT_QUOTES,'UTF-8'); ?>
            <?php } else     { ?>
              <?php echo htmlspecialchars(t('no specific action'),ENT_QUOTES,'UTF-8'); ?>
            <?php } ?>
          <?php } ?>
        </p>
      </span>
    </div>
  </a>
</td>
<td>
  <a class="tooltipbox">
    <div class="alert-gate-description">
      <?php echo htmlspecialchars($alert->gateShortLabel,ENT_QUOTES,'UTF-8'); ?>
    </div>
    <span>
      <p>
        <?php echo htmlspecialchars("{$alert->gateLabel}",ENT_QUOTES,'UTF-8'); ?>
      </p>
    </span>
  </a>
</td>
<td>
  <div class="alert-date-column">
    <?php echo htmlspecialchars(DateHelper::formatLocalDate($alert->alertDateTime),ENT_QUOTES,'UTF-8'); ?>
  </div>
</td>
<td>
  <div class="alert-time-column">
    <?php echo htmlspecialchars(DateHelper::formatISO9075Time($alert->alertDateTime),ENT_QUOTES,'UTF-8'); ?>
  </div>
</td>
<?php $speed = $alert->vehicleSpeed; ?>
<td><?php echo htmlspecialchars($speed,ENT_QUOTES,'UTF-8'); ?></td>
<?php if(!isset(Yii::app()->params['eventsToShow']) || Yii::app()->params['eventsToShow']!=="alarm") { ?>
  <td>
    <?php $this->renderPartial('/shared/_kemlerCode', array('kemlerCode'=>$alert->vehicleKemler)); ?>
  </td>
<?php } ?>
<td>
  <?php if(!Yii::app()->user->checkAccess('view_vehicle_landmarks')) { ?>
    <div class="vehicle-class-box">
      <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'vehicle-class-icon-small'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-classes/' . ($alert->vehicleClassIcon)))), 'html5', 'UTF-8'); ?> />
    </div>
  <?php } else   { ?>
    <div class="vehicle-class-box-full">
      <?php if ($alert->vehicleClassIcon) { ?>
        <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'vehicle-class-icon-small'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-classes/' . ($alert->vehicleClassIcon)))), 'html5', 'UTF-8'); ?> />
      <?php } ?>
      <?php if(!is_null($signList) || $alert->yellowBarType) { ?>
        <a class="signs-box pull-right tooltipbox">
          <div class="signs-box-speed-limit">
            <?php if(!is_null($signList)) { ?>
              <?php foreach($signList as $sign) { ?>
                <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'speed-limit-sign-icon-small'), array('src', ((Yii::app()->baseUrl) . '/images/speed-limit-signals/' . $sign . '.png'))), 'html5', 'UTF-8'); ?> />
              <?php } ?>
            <?php } ?>
          </div>
          <?php if($alert->yellowBarType) { ?>
            <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'yellow-bar-sign-icon-small'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-signs/yb_' . ($alert->yellowBarType) . '.png'))), 'html5', 'UTF-8'); ?> />
          <?php } ?>
          <span>
            <?php if(!is_null($signList)) { ?>
              <?php foreach($signList as $sign) { ?>
                <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'speed-limit-sign-icon-medium'), array('src', ((Yii::app()->baseUrl) . '/images/speed-limit-signals/' . $sign . '.png'))), 'html5', 'UTF-8'); ?> />
              <?php } ?>
            <?php } ?>
            <?php if($alert->yellowBarType) { ?>
              <img <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'yellow-bar-sign-icon-medium'), array('src', ((Yii::app()->baseUrl) . '/images/vehicle-signs/yb_' . ($alert->yellowBarType) . '.png'))), 'html5', 'UTF-8'); ?> />
            <?php } ?>
          </span>
        </a>
      <?php } ?>
    </div>
  <?php } ?>
</td>
<td>
  <?php if ($alert->hasAssociatedEvent()) { ?>
    <?php $colorSet = $alert->associatedEvent->colorSet; ?>
    <?php if (isset($colorSet) && $colorSet->computed) { ?>
      <?php $this->renderPartial('/shared/_colorSet', array('colors' => $colorSet->getColorsArray(3))); ?>
    <?php } ?>
  <?php } ?>
</td>
<td class="license-plate">
  <div class="licence-plate-box">
    <?php if($alert->hasAssociatedEvent()) { ?>
      <?php if($alert->nationalityCode != '') { ?>
        <?php $this->renderPartial('/shared/_countryFlag', array('isoCode' => $alert->associatedEvent->nationalityCode)); ?>
      <?php } else { ?>
        <img width="16px" />
      <?php } ?>
      <?php if(paramdeep('alerts','photoPreviewOnPlate')) { ?>
        <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($alert->previewPhotoUrl)), array('data-lightbox', ('alert-preview-' . ($alert->id)))), 'html5', 'UTF-8'); ?>>
          <?php if(Yii::app()->user->checkAccess('license_plate_visibility')) { ?>
            <?php echo htmlspecialchars($alert->plate,ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars("#######",ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </a>
        <?php if(strlen($alert->previewColorPhotoUrl) > 0)    { ?>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($alert->previewColorPhotoUrl)), array('data-lightbox', ('alert-preview-' . ($alert->id))), array('visibility', ('hidden'))), 'html5', 'UTF-8'); ?>></a>
        <?php } ?>
      <?php } else { ?>
        <?php if(Yii::app()->user->checkAccess('license_plate_visibility')) { ?>
          <?php echo htmlspecialchars($alert->plate,ENT_QUOTES,'UTF-8'); ?>
        <?php } else { ?>
          <?php echo htmlspecialchars("#######",ENT_QUOTES,'UTF-8'); ?>
        <?php } ?>
      <?php } ?>
    <?php } ?>
  </div>
</td>
