<div class="modal-header">
  <button class="close" type="button" data-dismiss="modal" aria-hidden="true">
    &times;
  </button>
  <h3><?php echo htmlspecialchars(Yii::t('app', 'Suggested violation articles'),ENT_QUOTES,'UTF-8'); ?></h3>
</div>
<div class="modal-body">
  <p><?php echo htmlspecialchars(Yii::t('app', 'Click on the right violation code'),ENT_QUOTES,'UTF-8'); ?></p>
  <table class="table table-condensed">
    <thead>
      <tr>
        <th><?php echo htmlspecialchars(Yii::t('app', 'Code'),ENT_QUOTES,'UTF-8'); ?></th>
        <th><?php echo htmlspecialchars(Yii::t('app', 'Description'),ENT_QUOTES,'UTF-8'); ?></th>
      </tr>
    </thead>
    <tbody></tbody>
    <?php foreach($violationCodes as $violationCode) { ?>
      <tr <?php echo MtHaml\Runtime::renderAttributes(array(array('data-code', ($violationCode->name)), array('data-description', ($violationCode->description))), 'html5', 'UTF-8'); ?>>
        <td class="code"><?php echo htmlspecialchars($violationCode->name,ENT_QUOTES,'UTF-8'); ?></td>
        <td class="description"><?php echo htmlspecialchars($violationCode->description,ENT_QUOTES,'UTF-8'); ?></td>
      </tr>
    <?php } ?>
  </table>
</div>
<div class="modal-footer">
  <button class="btn" type="button" data-dismiss="modal" aria-hidden="true"><?php echo htmlspecialchars(Yii::t('app', 'Cancel'),ENT_QUOTES,'UTF-8'); ?></button>
  <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'hidden'), array('name', 'eventBehaviorID'), array('value', ($eventBehavior->ID))), 'html5', 'UTF-8'); ?> />
  <input type="hidden" name="violationCode" value="" />
  <input type="hidden" name="violationCodeDescription" value="" />
  <button id="confirm-suggested-violation-code" class="btn btn-danger" type="button"><?php echo htmlspecialchars(Yii::t('app', 'OK'),ENT_QUOTES,'UTF-8'); ?></button>
</div>
