<div class="page-header">
  <h2>
    <div class="icon-pencil"></div>
    <?php echo htmlspecialchars(Yii::t("app", "Logs"),ENT_QUOTES,'UTF-8'); ?>
  </h2>
</div>
<table class="table table-condensed">
  <thead>
    <tr>
      <th><?php echo htmlspecialchars(t('Name'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Path'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Size'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Levels'),ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($logs as $log) { ?>
      <tr>
        <td>
          <?php if(file_exists($log->file)) { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('View'))), array('href', (url('debug/ViewAsText',array('filename'=>$log->file))))), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars($log->filename,ENT_QUOTES,'UTF-8'); ?>
            </a>
            <?php echo htmlspecialchars('(',ENT_QUOTES,'UTF-8'); ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('title', (t('Watch'))), array('href', (url('debug/WatchLog',array('filename'=>$log->file))))), 'html5', 'UTF-8'); ?>>
              <div class="icon-refresh"></div>
            </a>
            <?php echo htmlspecialchars(')',ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars($log->filename,ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
        <td>
          <?php if(file_exists($log->path)) { ?>
            <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', (url('debug/fileexplorer',array('path'=>$log->path))))), 'html5', 'UTF-8'); ?>>
              <?php echo htmlspecialchars($log->path,ENT_QUOTES,'UTF-8'); ?>
            </a>
          <?php } else { ?>
            <?php echo htmlspecialchars($log->path,ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
        <td>
          <?php if(file_exists($log->file)) { ?>
            <?php echo htmlspecialchars(formatBytes(filesize($log->file)),ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars(t('File not found'),ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
        <td>
          <?php if(count($log->levels)>0) { ?>
            <?php foreach($log->levels as $level) { ?>
              <?php if($level == CLogger::LEVEL_TRACE) { ?>
                <a title="LEVEL_TRACE" style="color: green;">
                  <div class="icon-random"></div>
                </a>
              <?php } elseif($level == CLogger::LEVEL_WARNING) { ?>
                <a title="LEVEL_WARNING" style="color: orange;">
                  <div class="icon-warning-sign"></div>
                </a>
              <?php } elseif($level == CLogger::LEVEL_ERROR) { ?>
                <a title="LEVEL_ERROR" style="color: red;">
                  <div class="icon-exclamation-sign"></div>
                </a>
              <?php } elseif($level == CLogger::LEVEL_INFO) { ?>
                <a title="LEVEL_INFO" style="color: blue;">
                  <div class="icon-info-sign"></div>
                </a>
              <?php } elseif($level == CLogger::LEVEL_PROFILE) { ?>
                <a title="LEVEL_PROFILE" style="color: violet;">
                  <div class="icon-bar-chart"></div>
                </a>
              <?php } else { ?>
                <?php echo htmlspecialchars($level,ENT_QUOTES,'UTF-8'); ?>
              <?php } ?>
            <?php } ?>
          <?php } ?>
        </td>
      </tr>
    <?php } ?>
  </tbody>
</table>
<form>
  <?php echo htmlspecialchars(t("Filters:"),ENT_QUOTES,'UTF-8'); ?>
  <input <?php echo MtHaml\Runtime::renderAttributes(array(array('type', 'text'), array('name', 'filters'), array('value', $filters)), 'html5', 'UTF-8'); ?> />
</form>
