<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of PlateQueryIntegrator
 *
 * @author a.ronchi
 */
class PlateQueryIntegrator {

    public $fullName;
    public $shortName;
    public $selectPart;
    public $wherePart;
    public $whereParams;
    public $correspondingField;

    function __construct($fullName, $shortName, $selectPart = null, $wherePart = null, $correspondingField = null) {
        $this->fullName = $fullName;
        $this->shortName = $shortName;
        $this->selectPart = $selectPart;
        $this->wherePart = $this->fixStartOrEndParenthesis($wherePart);
        $this->whereParams = array();
        $this->correspondingField = $correspondingField;
    }

    function __get($name) {
        switch ($name) {
            case "composedName":
                return $this->fullName . ' ' . $this->shortName;
            case "fullQuery":
                return empty($this->wherePart) ? null : "SELECT $this->selectPart FROM " . $this->composedName . " WHERE " . $this->wherePart;
            case "validQuery":
                return !empty($this->wherePart);
            default:
                return parent::__get($name);
        }
    }

    function addWhereClause($santa, $conjunction = null) {
        $portionToAppend = $this->fixStartOrEndParenthesis($santa);
        if (!empty($this->wherePart)) {
            if (!is_null($conjunction) && !is_null($santa)) {
                $portionToAppend = " $conjunction (" . $portionToAppend . ")";
            }
        }
        $this->wherePart .= $portionToAppend;
    }

    function addWhereParams($key, $value) {
        $this->whereParams[$key] = $value;
    }

    function addWhereParamsBulk($paramsArray) {
        foreach ($paramsArray as $currentParamKey => $currentParamValue) {
            if (strpos($this->wherePart, $currentParamKey) !== FALSE) {
                $this->whereParams[$currentParamKey] = $currentParamValue;
            }
        }
    }

    function addSelectClause($santa) {
        $this->selectPart .= ", " . $santa;
    }

    function resetWhereComplete() {
        $this->wherePart = "";
        $this->whereParams = array();
    }

    function getQueryGeneratedFilter() {
        if (!empty($this->selectPart) && !empty($this->wherePart)) {
            $resultFilter = array();
            $cmd = Yii::app()->db->createCommand();
            $cmd->select($this->selectPart)->from($this->composedName)->where($this->wherePart, $this->whereParams);
            $result = $cmd->query();
            foreach ($result as $row) {
                $resultFilter[] = $row['ID'];
            }
            if (count($result) > 0) {
                return $this->correspondingField . " IN (" . implode(",", $resultFilter) . ")";
            }
        }
    }

    private function fixStartOrEndParenthesis($targetString) {
        $openBrackets = substr_count($targetString, '(');
        $closedBrackets = substr_count($targetString, ')');
        $parethensisSum = $openBrackets - $closedBrackets;
        switch ($this->sign($parethensisSum)) {
            case "N":
                return $targetString;
            case "-":
                return '(' . $targetString;
            case "+":
                return $targetString . ')';
        }
    }

    private function sign($number) {
        if ($number > 0) {
            return "+";
        }
        if ($number < 0) {
            return "-";
        }
        return "N";
    }

}
