<?php

class LoggerInfo
{

  public $name;

  public $fields = array ();

  /**
   * 
   * @return LoggerInfo[]
   */
  public static function findAllLoggers()
  {
    $loggers = array ();
    
    if (is_abstract_class ( "CDbLogRoute" ))
      array_add_unique ( $loggers, "CDbLogRoute" );
    if (is_abstract_class ( "CEmailLogRoute" ))
      array_add_unique ( $loggers, "CEmailLogRoute" );
    if (is_abstract_class ( "CFileLogRoute" ))
      array_add_unique ( $loggers, "CFileLogRoute" );
    if (is_abstract_class ( "CProfileLogRoute" ))
      array_add_unique ( $loggers, "CProfileLogRoute" );
    if (is_abstract_class ( "CWebLogRoute" ))
      array_add_unique ( $loggers, "CWebLogRoute" );
    
    foreach ( get_declared_classes () as $className )
    {
      $classOriginal = new ReflectionClass ( $className );
      if ($classOriginal->isAbstract ())
        continue;
      $class = new ReflectionClass ( $className );
      while ( $class != null )
      {
        if ($class->getName () == 'CLogRoute')
        {
          array_add_unique ( $loggers, $className );
          break;
        }
        $class = $class->getParentClass ();
      }
    }
    
    $loggersInfo = array ();
    foreach ( $loggers as $loggerClass )
    {
      $class = new ReflectionClass ( $loggerClass );
      $info = new LoggerInfo();
      $info->name = $loggerClass;
      $info->fields = get_class_vars ( $loggerClass );
      $loggersInfo [$loggerClass] = $info;
    }
    
    return $loggersInfo;
  }
}