<?php

/**
 * Manage a folder into protected/runtime
 * @author p.treu
 *
 */
class RuntimeFolder
{

  /**
   *
   * @var string
   */
  public $name;

  /**
   *
   * @var string
   */
  public $path;

  public function __construct($name)
  {
    $this->name = $name;
    $this->path = pathCombine ( app ()->runtimePath, $name );
    if (! dirExists ( $this->path ))
      mkdir ( $this->path );
    $this->path = realpath ( $this->path );
  }

  public function __toString()
  {
    return "RUNTIME FOLDER: $name";
  }

  /**
   *
   * @return DirectoryIterator
   */
  public function getIterator()
  {
    return new DirectoryIterator ( $this->path );
  }

  /**
   *
   * @return multitype:string
   */
  public function getFiles()
  {
    $files = array ();
    foreach ( $this->getIterator () as $file )
      if ($file->isFile ())
        $files [] = $file->getRealPath ();
    return $files;
  }
}
