<?php

class ExportRegistrationController extends Controller
{

  protected function beforeAction($event)
  {
    //access_denied_check ( "export_history_report" );
    return parent::beforeAction ( $event );
  }

  /**
   *
   * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
   *      using two-column layout. See 'protected/views/layouts/column2.php'.
   */

  

  /**
   * Displays a particular model.
   *
   * @param integer $id
   *          the ID of the model to be displayedSectionController.php
   */
  public function actionAdmin()
  {
  	
  	if(access_denied_check('export_history_report'))
  		return false;
  		 
  		 
  	if(user()->checkAccess('export_history_report_all_servers'))
  	{
  		$evenServers = EventServerRegistration::model()->findAll();
 		 
  		$months = DateHelper::getMonthListToNow(12);
  		 
  		$now = new Datetime('now');
  		 
  		$nowMinusOneYear = clone $now;
  		 
  		$nowMinusOneYear = $nowMinusOneYear->sub(new DateInterval('P1Y2M'));
  		 
  		$exportStats = ExportedEvents::model()->sumInTimeInterval($nowMinusOneYear, $now, false)->findAll();
  		 
  		$expCounters = array();
  		 
  		foreach ($exportStats as $exportStat)
  		{
  			$a1 = array('exported' => $exportStat->exported, 'deleted' => $exportStat->deleted);
  		
  		
  			$am = array("$exportStat->month" => $a1);
  			$ay = array("$exportStat->year" => $am);
  			$ag = array("$exportStat->id_event_server" => $ay);
  		
  			if(array_key_exists("$exportStat->id_event_server", $expCounters))
  			{
  				if(array_key_exists("$exportStat->year", $expCounters["$exportStat->id_event_server"]))
  				{
  					$expCounters["$exportStat->id_event_server"]["$exportStat->year"]["$exportStat->month"] = $a1;
  				}
  				else
  				{
  					$expCounters["$exportStat->id_event_server"]["$exportStat->year"] = $am;
  				}
  			}
  			else
  			{
  				$expCounters["$exportStat->id_event_server"] = $ay;
  			}
  		}
  		
  		
  		$this->render ('admin', array('eventServers' => $evenServers, 'months' => $months, 'expCounters' => $expCounters));
  	}
    else
  	{
  		$evenServers = EventServerRegistration::model()->byMe()->find();
  		
  		
  		$wPeriodC = WorkPeriod::model()->to_register()->count();
  		
  		if($wPeriodC > 0)
  		{
  			
  			$this->render ('serverDetailsUnavailable');
  		}
  		
  		self::actionServerDetails($evenServers->id);
  	}

  }

  public function actionServerDetails($idServer)
  {
  	 
  	if(access_denied_check('export_history_report'))
  		return false;
  	
  		
  	$eventServer =  EventServerRegistration::model()->byId($idServer)->find();
  	
  		
  	$gates = ExportedEvents::model()->byServer($idServer)->getGates()->findAll();
  	
  	$months = DateHelper::getMonthListToNow(12);
  	
  	$now = new Datetime('now');
  	
  	$nowMinusOneYear = clone $now;
  	

  	
  	$nowMinusOneYear = $nowMinusOneYear->sub(new DateInterval('P1Y2M'));
  	
  	
  	$exportStats = ExportedEvents::model()->byServer($idServer)->sumInTimeInterval($nowMinusOneYear, $now, true)->findAll();
  	
  	$expCounters = array();
  	
  	foreach ($exportStats as $exportStat)
  	{
  		$a1 = array('exported' => $exportStat->exported, 'deleted' => $exportStat->deleted);

  		
  		$am = array("$exportStat->month" => $a1);
  		$ay = array("$exportStat->year" => $am);
  		$ag = array("$exportStat->gate_sn" => $ay);
  		
  		if(array_key_exists("$exportStat->gate_sn", $expCounters))
  		{
  			if(array_key_exists("$exportStat->year", $expCounters["$exportStat->gate_sn"]))
  			{
  				$expCounters["$exportStat->gate_sn"]["$exportStat->year"]["$exportStat->month"] = $a1;
  			}
  			else
  			{
  				$expCounters["$exportStat->gate_sn"]["$exportStat->year"] = $am;
  			}	
  		}
  		else 
  		{
  			$expCounters["$exportStat->gate_sn"] = $ay;
  		}
  	}  		 
  	
  	$this->render ('serverDetails', array('eventServer' => $eventServer, 'gates' => $gates, 'months' => $months, 'expCounters' => $expCounters));
  }
 
  
}
