<?php

/**
 * @property string IDLista
 * @property string IDPermesso
 * @property string IDAbbonamento
 * @property string IDVeicolo
 * @property string IDUtente
 * @property string Nome
 * @property string Lista
 * @property string Cognome
 * @property string Targa
 * @property string Nationality
 * @property string DataInizio
 * @property string DataFine
 * @property string Epoch
 * @property string Enabled
 * @property string ToBeConfirmed
 * @property string statusText
 * @property string statusColor
 * @property string expired
 * @property string aboutToExpire
 * @property string elapsed
 * @property string url_return
 * @property string url_renew
 * @property string url_revoke
 * @property string url_delete
 * @property string url_view
 * @property string url_confirm
 * @property string IDGate
 * @property string IDGate_type
 * @property string IDTime
 * @property string GateDescr
 * @property string TimeDescr
 * @property string DescrizionePermesso
 * @property string DescrizioneVeicolo
 * @property string DescrizionePeriodo
 * @property Gate GateObj
 * @property GateSet GateSetObj
 * @property GateGroup GateGroupObj
 * @property TimeSchedule TimeObj
 * @property string ModeLista
 * @property bool ListaIsBlack
 * @property bool ListaIsWhite
 **/
class SmartPlateAuth extends CArray
{

  public function __construct(Array $properties = array())
  {
    parent::__construct ( $properties );
  }

  /**
   *
   * @param int $gate          
   * @param string $timestamp          
   * @return boolean
   */
  public function allowed($gate, $timestamp)
  {
    return ($this->Enabled && ! $this->ToBeConfirmed && $this->containsDate ( $timestamp ) && $this->containsGate ( $gate ));
  }

  public function containsGate($gate)
  {
    if ($this->IDGate == - 1)
      return true;
    
    if ($gate instanceof Gate)
      $gate = $gate->Gate;
    
    if ($this->GateObj != null)
      if ($this->GateObj->Gate == $gate)
        return true;
    
    if ($this->GateSetObj != null)
      foreach ( $this->GateSetObj->gates as $g )
        if ($g->Gate == $gate)
          return true;
    
    if ($this->GateGroupObj != null)
      foreach ( $this->GateGroupObj->gates as $g )
        if ($g->Gate == $gate)
          return true;
    
    return false;
  }

  public function containsDateRange($date = null)
  {
    $date = DateHelper::ensureObject ( $date );
    return (date_in_range ( $this->DataInizio, $this->DataFine, $date ));
  }

  public function containsDate($date = null)
  {
    $date = DateHelper::ensureObject ( $date );
    if ($this->containsDateRange ( $date ))
      return $this->containsTimeSchedule ( $date );
    return false;
  }

  public function containsTimeSchedule($date = null)
  {
    $date = DateHelper::ensureObject ( $date );
    if ($this->IDTime == - 1)
      return true;
    /** @var TimeSchedule $timeObj */
    $timeObj = $this->TimeObj;
    if ($timeObj == null)
      return false;
    $slot = $timeObj->getBestSlotToday ( $date );
    
    if(is_null($slot))
    	return false;
    
    return true;
  }
}

