<h2><?php echo htmlspecialchars(t('Violation Document List Details'),ENT_QUOTES,'UTF-8'); ?></h2>
<table class="report-table">
  <thead>
    <tr class="report-table-header">
      <td><?php echo htmlspecialchars(t('Verbale'),ENT_QUOTES,'UTF-8'); ?></td>
      <td><?php echo htmlspecialchars(t('Violation Date'),ENT_QUOTES,'UTF-8'); ?></td>
      <td><?php echo htmlspecialchars(t('Violation Time'),ENT_QUOTES,'UTF-8'); ?></td>
      <td><?php echo htmlspecialchars(t('License Plate N.'),ENT_QUOTES,'UTF-8'); ?></td>
      <td><?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?></td>
      <td><?php echo htmlspecialchars(t('Violation Code') ,ENT_QUOTES,'UTF-8'); ?></td>
    </tr>
  </thead>
  <tbody>
    <?php foreach($events as $event) { ?>
      <?php if ($event->ext_code != ExtCode::NULL_EXT_CODE)     { ?>
        <?php $challengedSpeed = CalculateChallengedSpeed::run($event->Speed, Yii::app()->params['spotSpeedViolation']['percentageTolerance'], Yii::app()->params['spotSpeedViolation']['fixedTolerance'], Yii::app()->params['spotSpeedViolation']['toleranceTable']);; ?>
        <?php $challengedSpeed = number_format($challengedSpeed,2); ?>
        <tr>
          <td><?php echo htmlspecialchars($event->ext_code,ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars(DateHelper::formatISO9075Date($event->StartTime),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars(DateHelper::formatISO9075Time($event->StartTime),ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->Plate,ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars($event->Gate,ENT_QUOTES,'UTF-8'); ?></td>
          <td><?php echo htmlspecialchars(implode(';', $event->violationCodes),ENT_QUOTES,'UTF-8'); ?></td>
        </tr>
      <?php } ?>
    <?php } ?>
  </tbody>
</table>
