<?php $gateObj = Gate::getByCode($gate); ?>
<?php $allowedCounter = 0; ?>
<h2><?php echo htmlspecialchars(t('Plate authorizations for transit'),ENT_QUOTES,'UTF-8'); ?></h2>
<h4><?php echo htmlspecialchars(t('Plate').': '.$plate,ENT_QUOTES,'UTF-8'); ?></h4>
<h4><?php echo htmlspecialchars(t('Gate').': '.$gateObj->Descrizione." ($gate)",ENT_QUOTES,'UTF-8'); ?></h4>
<h4><?php echo htmlspecialchars(t('Time').': '.$time,ENT_QUOTES,'UTF-8'); ?></h4>
<table class="table table-condensed">
  <thead>
    <tr>
      <th></th>
      <th><?php echo htmlspecialchars('ID',ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('List'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Active'),ENT_QUOTES,'UTF-8'); ?></th>
      <th><?php echo htmlspecialchars(t('Confirmed'),ENT_QUOTES,'UTF-8'); ?></th>
      <th></th>
      <th><?php echo htmlspecialchars(t('Gate'),ENT_QUOTES,'UTF-8'); ?></th>
      <th></th>
      <th><?php echo htmlspecialchars(t('Time schedule'),ENT_QUOTES,'UTF-8'); ?></th>
      <th></th>
      <th><?php echo htmlspecialchars(t('Start date'),ENT_QUOTES,'UTF-8'); ?></th>
      <th></th>
      <th><?php echo htmlspecialchars(t('End date'),ENT_QUOTES,'UTF-8'); ?></th>
      <th style="border-left: 1px solid #dddddd;"></th>
      <th><?php echo htmlspecialchars(t('Result'),ENT_QUOTES,'UTF-8'); ?></th>
    </tr>
  </thead>
  <tbody>
    <?php foreach($plateAuths as $p) { ?>
      <?php $allowed = $p->allowed($gate,$time); ?>
      <?php if($allowed) { ?>
        <?php $allowedCounter++; ?>
      <?php } ?>
      <tr>
        <td>
          <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'icon-eye-open'), array('href', ($p->url_view)), array('title', (t('View')))), 'html5', 'UTF-8'); ?>></a>
        </td>
        <td>
          <?php echo htmlspecialchars($p->IDPermesso,ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php echo htmlspecialchars($p->Lista,ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php if($p->Enabled) { ?>
            <div class="color-green icon-ok"></div>
          <?php } else { ?>
            <div class="color-red icon-remove"></div>
          <?php } ?>
        </td>
        <td>
          <?php if($p->ToBeConfirmed) { ?>
            <div class="color-red icon-remove"></div>
          <?php } else { ?>
            <div class="color-green icon-ok"></div>
          <?php } ?>
        </td>
        <td>
          <?php if($p->containsGate($gate)) { ?>
            <div class="color-green icon-ok"></div>
          <?php } else { ?>
            <div class="color-red icon-remove"></div>
          <?php } ?>
        </td>
        <td>
          <?php echo SystemInfoHelper::getPlateAuthGateCoolName($p->IDGate,$p->IDGate_type); ?>
        </td>
        <td>
          <?php if($p->containsTimeSchedule($timestamp)) { ?>
            <div class="color-green icon-ok"></div>
          <?php } else { ?>
            <div class="color-red icon-remove"></div>
          <?php } ?>
        </td>
        <td>
          <?php echo SystemInfoHelper::getTimeScheduleCoolName($p->IDTime); ?>
        </td>
        <td>
          <?php if($p->DataInizio <= $time) { ?>
            <div class="color-green icon-ok"></div>
          <?php } else { ?>
            <div class="color-red icon-remove"></div>
          <?php } ?>
        </td>
        <td>
          <?php echo htmlspecialchars($p->DataInizio,ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td>
          <?php if($p->DataFine >= $time) { ?>
            <div class="color-green icon-ok"></div>
          <?php } else { ?>
            <div class="color-red icon-remove"></div>
          <?php } ?>
        </td>
        <td>
          <?php echo htmlspecialchars($p->DataFine,ENT_QUOTES,'UTF-8'); ?>
        </td>
        <td style="border-left: 1px solid #dddddd;">
          <?php if($allowed) { ?>
            <div class="color-green icon-ok"></div>
          <?php } else { ?>
            <div class="color-red icon-remove"></div>
          <?php } ?>
        </td>
        <td>
          <?php if($allowed) { ?>
            <?php echo htmlspecialchars(t('Authorized'),ENT_QUOTES,'UTF-8'); ?>
          <?php } else { ?>
            <?php echo htmlspecialchars(t('Unauthorized'),ENT_QUOTES,'UTF-8'); ?>
          <?php } ?>
        </td>
      </tr>
    <?php } ?>
    <tr>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
      <td></td>
    </tr>
  </tbody>
</table>
<?php if($allowedCounter > 0) { ?>
  <h1 class="color-green"><?php echo htmlspecialchars(t('Authorized transit'),ENT_QUOTES,'UTF-8'); ?></h1>
<?php } else { ?>
  <h1 class="color-red"><?php echo htmlspecialchars(t('Unauthorized transit'),ENT_QUOTES,'UTF-8'); ?></h1>
<?php } ?>
<?php if(user()->checkAccess('plate_auth_status') && user()->checkAccess('plate_auth_status_global')) { ?>
  <h4>
    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('class', 'btn'), array('target', '_blank'), array('href', (url('plateAuthorization/whitelistStatus', array('plateListId'=>-1, 'search'=>$plate)))), array('style', 'margin-left: 10px;')), 'html5', 'UTF-8'); ?>>
      <?php echo htmlspecialchars(t('View all'),ENT_QUOTES,'UTF-8'); ?>
    </a>
  </h4>
<?php } ?>
