<table class="table table-condensed">
  <thead>
    <tr>
      <th>
        <?php echo htmlspecialchars(t('Operation'),ENT_QUOTES,'UTF-8'); ?>
      </th>
      <th>
        <?php echo htmlspecialchars(t('User'),ENT_QUOTES,'UTF-8'); ?>
      </th>
      <th>
        <?php echo htmlspecialchars(t('Date'),ENT_QUOTES,'UTF-8'); ?>
      </th>
      <th>
        <?php echo htmlspecialchars(t('Time'),ENT_QUOTES,'UTF-8'); ?>
      </th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td>
        <a class="tooltipbox">
          <div class="plateauth-action-description">
            <?php echo htmlspecialchars(t('Creation') ,ENT_QUOTES,'UTF-8'); ?>
            <span>
              <p>
                <?php echo htmlspecialchars(t('no specific note'),ENT_QUOTES,'UTF-8'); ?>
              </p>
            </span>
          </div>
        </a>
      </td>
      <td>
        <?php echo htmlspecialchars($plateAuthorization->getSubmitter(),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(DateHelper::formatLocalDate($plateAuthorization->epoch),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(DateHelper::formatISO9075Time($plateAuthorization->epoch),ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
  </tbody>
  <?php foreach($plateAuthorization->actions as $action) { ?>
    <tr>
      <td>
        <a class="tooltipbox">
          <div class="plateauth-action-description">
            <?php echo htmlspecialchars(t(PlateAuthActionHelper::getActionName($action->action)) ,ENT_QUOTES,'UTF-8'); ?>
            <span>
              <p>
                <?php if(strlen($action->note) > 0)   { ?>
                  <?php echo htmlspecialchars("{$action->note}",ENT_QUOTES,'UTF-8'); ?>
                <?php } else     { ?>
                  <?php echo htmlspecialchars(t('no specific note'),ENT_QUOTES,'UTF-8'); ?>
                <?php } ?>
              </p>
            </span>
          </div>
        </a>
      </td>
      <td>
        <?php echo htmlspecialchars($action->getSubmitter(),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(DateHelper::formatLocalDate($action->epoch),ENT_QUOTES,'UTF-8'); ?>
      </td>
      <td>
        <?php echo htmlspecialchars(DateHelper::formatISO9075Time($action->epoch),ENT_QUOTES,'UTF-8'); ?>
      </td>
    </tr>
  <?php } ?>
</table>
