<?php $form=$this->beginWidget('bootstrap.widgets.TbActiveForm',array(
    'id'=>'plate-auth-insert-profile-form',
    'enableAjaxValidation'=>false,
));

$whitelists = array();
$whitelists[-1] = t("Any");
foreach(PlateList::getCurrentUserLists() as $l)
  $whitelists[$l->code] = "[{$l->getListType()}] {$l->getListTitle()}";

$form = new TbActiveForm();

?>

<p class="help-block">
  Fields with <span class="required">*</span> are required.
</p>

<?php echo $form->errorSummary($model); ?>

<?php echo $form->textFieldRow($model,'name',array('class'=>'span5')); ?>

<?php echo $form->textFieldRow($model,'description',array('class'=>'span5')); ?>
(
<?php echo t('For example: "Insert whitelist Hotel Red"'); ?>
)
<br />

<?php echo $form->dropDownListRow($model,'list_code',$whitelists,array('class'=>'span5')); ?>

<h3>Fields</h3>

<?php if(is_array_ex($fields)) { ?>

<table class="table table.condensed">
  <thead>
    <tr>
      <th title="Order">#</th>
      <th title="Column">C</th>
      <th>Name</th>
      <th>Type</th>
      <th>Label</th>
      <th><span class="icon-exclamation" title="Required"></span></th>
      <th><span class="icon-eye-open" title="Visible"></span></th>
      <th><span class="icon-pencil" title="Editable"></span></th>
      <th>Default</th>
      <th>Values</th>
      <th>Comment</th>
      <th>Description</th>
      <th>Group</th>
    </tr>
  </thead>
  <tbody>
    <?php 
    $lastGroup = "";
    foreach($fields as $field) if($field instanceof PlateAuthInsertProfileField)
    {
      if($lastGroup != $field->group)
      {
        $lastGroup = $field->group;
        ?>
    <tr>
      <td colspan="9"><?php
      echo("<center><i><b>".t(ucfirst($field->group))."</b></i></center>");
      ?>
      </td>
    </tr>
    <?php 
      }

      $field_id = "fielddata_{$field->name}";
      ?>
    <tr>
      <td><?php       
      echo CHtml::textField("{$field_id}[order]", $field->order, array('style'=>'width: 20px;'));
      ?>
      </td>
      <td><?php       
      echo CHtml::textField("{$field_id}[column]", $field->column, array('style'=>'width: 20px;'));
      ?>
      </td>
      <td><?php             
      echo CHtml::textField("{$field_id}[name]", $field->name, array('class'=>'monospace', 'readonly'=>'readonly')); ?>
      </td>
      <td><?php echo CHtml::dropDownList("{$field_id}[type]", $field->type, PlateAuthInsertProfileFieldType::getValues(), array('class'=>'monospace')); ?>
      </td>
      <td><?php echo CHtml::textField("{$field_id}[label]", $field->label, array('class'=>'monospace')); ?>
      </td>
      <td><?php echo CHtml::checkBox("{$field_id}[required]", $field->required, array('title'=>'Required')); ?>
      </td>
      <td><?php echo CHtml::checkBox("{$field_id}[visible]", $field->visible, array('title'=>'Visible')); ?>
      </td>
      <td><?php echo CHtml::checkBox("{$field_id}[editable]", $field->editable, array('title'=>'Editable')); ?>
      </td>
      <td><?php echo CHtml::textField("{$field_id}[default]", $field->default, array('class'=>'monospace')); 
      if(DebugController::isDebugging() && !isEmptyOrWhitespace($field->default))
      {
        $code = "return ({$field->default});";
        $evalUrl = url('debug/eval', array('code'=>$code, 'do_eval'=>1, 'as_value'=>1));
        echo("<a target=\"_blank\" href=\"$evalUrl\"><span class=\"icon-code\"></span></a>");
      }
      ?>
      </td>
      <td><?php echo CHtml::textArea("{$field_id}[values]", $field->values, array('class'=>'monospace')); 
      if(DebugController::isDebugging() && !isEmptyOrWhitespace($field->values))
      {
        $code = "return ({$field->values});";
        $evalUrl = url('debug/eval', array('code'=>$code, 'do_eval'=>1, 'as_value'=>1));
        echo("<a target=\"_blank\" href=\"$evalUrl\"><span class=\"icon-code\"></span></a>");
      }
      ?>
      </td>
      <td><?php echo CHtml::textArea("{$field_id}[comment]", $field->comment, array('class'=>'monospace')); ?>
      </td>
      <td><?php echo CHtml::textArea("{$field_id}[description]", $field->description, array('class'=>'monospace')); ?>
      </td>
      <td><?php echo CHtml::textField("{$field_id}[group]", $field->group, array('class'=>'monospace')); ?>
      </td>
    </tr>
    <?php } ?>
  </tbody>
</table>

<?php } else { 
  echo("<b><center>Fields not found!</center></b>");
}?>

<div class="form-actions">
  <?php $this->widget('bootstrap.widgets.TbButton', array(
      'buttonType'=>'submit',
      'type'=>'primary',
      'label'=>$model->isNewRecord ? 'Create' : 'Save',
		)); ?>
</div>

<?php $this->endWidget(); ?>
