#= require ./behavior

class window.DatePickSetter extends window.Behavior

  init: ->
    @range = @data('datepick-setter-range', 7)
    @mode = @data('datepick-setter-mode', 'date')

    @$dom.click =>
      @setPickers()

  startDom: ->
    @domData('datepick-setter-start-target')

  endDom: ->
    @domData('datepick-setter-end-target')

  startDate: ->
    moment().subtract('days', @range)

  endDate: ->
    moment()

  setPickers: ->
    if (@mode == 'datetime')
      @startDom().datetimepicker('setLocalDate', @startDate().startOf('day').toDate()).change()
      @endDom().datetimepicker('setLocalDate', @endDate().endOf('day').toDate()).change()
    else
      @startDom().datepicker('setDate', @startDate().toDate()).change()
      @endDom().datepicker('setDate', @endDate().toDate()).change()
