<?php

class Enum
{
  public $key = null;
  public $value = null;

  public static function valueExists($value)
  {
    return array_key_exists($value,self::getValues());
  }

  public static function getValues()
  {
    $class = new ReflectionClass(get_called_class());
    return $class->getConstants();
  }

  /**
   *
   * @return Enum
   */
  public static function getEnums()
  {
    $className = get_called_class();
    $class = new ReflectionClass($className);
    $enums = array();
    foreach($class->getConstants() as $key => $value)
    {
      $obj = new $className;
      $obj->key = $key;
      $obj->value = $value;
      $enums[] = $obj;
    }
    return $enums;
  }

  /**
   * @param $value
   * @return Enum
   */
  public static function parse($value)
  {
    $className = get_called_class();
    $enums = $className::getEnums();
    foreach($enums as $obj)
    if($obj->value == $value)
      return $obj;
    return null;
  }

  /**
   * @param $value
   * @return string
   */
  public static function getKey($value)
  {
    $className = get_called_class();
    $obj = $className::parse($value);
    if($obj!=null)
      return $obj->key;
    return null;
  }
  
  public function __toString()
  {

  }
}
