<?php

class PaySlipController extends Controller
{
  public $layout='//layouts/print';

  public function filters()
  {
    return array(
      'postOnly + create',
    	array('application.filters.SyslogFilter + confirm, create',),
    );
  }

  public function actionConfirm($workPeriodID)
  {
    // ensure work period really exists
    $workPeriod = $this->loadWorkPeriod($workPeriodID);

    $this->renderPartial('_confirm', array('workPeriodID' => $workPeriod->id, 'workPeriodClosed' => $workPeriod->closed));
  }

  public function actionViewSummary($workPeriodID)
  {
    $period = $this->loadWorkPeriod($workPeriodID);
    $paySlip = new PaySlip($period);
    $this->renderPartial('/paySlip/_summary', array('workPeriodID' => $workPeriodID, 'paySlip' => $paySlip));
  }

  public function actionCreate()
  {
    if (!isset($_POST['workPeriodID']))
      throw new CHttpException(400, Yii::app('t', 'workPeriodID is required.'));

    $workPeriodID = (int) $_POST['workPeriodID'];
    $period = $this->loadWorkPeriod($workPeriodID);
    $paySlip = new PaySlip($period);
    $templateParams = array('period' => $period, 'paySlip' => $paySlip);

    if(!$period->closed)
    	Yii::app()->user->logout();
    
    $this->render('create', $templateParams);
  }

  public function loadWorkPeriod($id)
  {
    $period = WorkPeriod::model()->findByPk($id);
    if($period === null)
      throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
    return $period;
  }

}
