<div>
  <div>
    <div class="tableContainer pagination-data-container">
      <table class="table table-condensed span12">
        <thead>
          <tr></tr>
          <tr>
            <?php if(user()->checkAccess('view_live')) { ?>
              <th></th>
            <?php } ?>
            <th></th>
            <th><?php echo htmlspecialchars(t('ID'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Description'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('S/N'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('IP'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Device'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Group'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Short name'),ENT_QUOTES,'UTF-8'); ?></th>
            <th><?php echo htmlspecialchars(t('Code'),ENT_QUOTES,'UTF-8'); ?></th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($gates as $gate) { ?>
            <?php $gate = new GatePresenter($gate); ?>
            <tr>
              <?php if(user()->checkAccess('view_live')) { ?>
                <td>
                  <?php if($gate->hasLive()) { ?>
                    <a <?php echo MtHaml\Runtime::renderAttributes(array(array('href', ($gate->LivePageUrl)), array('target', '_blank'), array('title', (t('Live')))), 'html5', 'UTF-8'); ?>>
                      <div class="icon-facetime-video"></div>
                    </a>
                  <?php } ?>
                </td>
              <?php } ?>
              <td>
                <span <?php echo MtHaml\Runtime::renderAttributes(array(array('class', ('status-icon' . ' ' . 'icon-circle')), array('class', ($gate->statusClass)), array('title', ($gate->statusClass))), 'html5', 'UTF-8'); ?>></span>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->ID,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->Descrizione,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->Gate,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->IP,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars(t($gate->GateType),ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo SystemInfoHelper::getGateGroupCoolName($gate->id_group); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->short_name,ENT_QUOTES,'UTF-8'); ?>
              </td>
              <td>
                <?php echo htmlspecialchars($gate->Code,ENT_QUOTES,'UTF-8'); ?>
              </td>
            </tr>
          <?php } ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
