<?php
$this->breadcrumbs=array(
	'Gates'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List Gate','url'=>array('index')),
	array('label'=>'Create Gate','url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('gate-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Gates</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('Advanced Search','#',array('class'=>'search-button btn')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('bootstrap.widgets.TbGridView',array(
	'id'=>'gate-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(
		'ID',
		'Descrizione',
		'Matricola',
		'ValidationMaxDelay',
		'Type',
		'Gate',
		/*
		'Enable',
		'IP',
		'Code',
		'LinkedGate',
		'epoch',
		'AreaSourceID',
		'AreaDestinationID',
		'Status',
		'LastLifeSignal',
		'Homologation',
		'LastEventID',
		'LifeSignalTimeOut',
		'LastEventTime',
		'GateType',
		'id_group',
		'speed_limit',
		'last_exported_event_id',
		'last_exported_event_time',
		'last_exported_event_validation_time',
		'latitude',
		'longitude',
		'altitude',
		'short_name',
		'live_url',
		'work_mode',
		*/
		array(
			'class'=>'bootstrap.widgets.TbButtonColumn',
		),
	),
)); ?>
