<?php

register_shutdown_function( "fatal_handler" );

function fatal_handler() 
{
  $error = error_get_last();
  if( $error === NULL) {
    $error = 'last error not found';
  }  
  var_dump($error);
}

function exception_error_handler($errno, $errstr, $errfile, $errline ) {
  var_dump(array('errstr'=>$errstr, 'errno'=>$errno, 'errfile'=>$errfile, 'errline'=>$errline));
}
set_error_handler("exception_error_handler");

try{

require_once(dirname(__FILE__) . '/protected/extensions/yii-environment/Environment.php');
$env = new Environment();

defined('YII_DEBUG') or define('YII_DEBUG', $env->yiiDebug);
defined('YII_TRACE_LEVEL') or define('YII_TRACE_LEVEL', $env->yiiTraceLevel);

require_once(dirname(__FILE__).'/protected/globals.php');
require_once($env->yiiPath);
$env->runYiiStatics();
$app = Yii::createWebApplication($env->configWeb);

spl_autoload_unregister(array('YiiBase','autoload'));
require_once('log4php/Logger.php'); // require registers Logger autoload
spl_autoload_register(array('YiiBase','autoload'));


$app->params['environment'] = $env->determineMode();

Logger::configure($app->params['log4php']);

$app->run();

}catch (Exception $e)
{
  var_dump($e);
}