#= require ./behavior
#= require ./mixins/refreshAlertPreviewTable

class window.AlertsPreview extends window.Behavior
  @include window.RefreshAlertPreviewTable

  init: ->
    @$alertsContainer = @$dom
    @$dom.on 'click', '.update-alerts-preview', =>
      @refreshAlertsTable(@getGateId())
    @autoUpdate()

  autoUpdate: ->
    setInterval(
      =>
        if @shouldAutoUpdate()
          @refreshAlertsTable(@getGateId())
      , 5000
    )

  getGateId: ->
    @data('gate-id')

  shouldAutoUpdate: ->
    @$dom.find('.automatic-alerts-preview').is(':checked')
