#= require ./behavior

class CartographyGateLegacy
  constructor: (data, index) ->
    @gate = data.gate
    @alerts = data.alerts

  getStatus: ->
    if @gate.Status == "ALIVE" then 1 else 0

  getKey: ->
    @gate.Gate

  getName: ->
    @gate.Descrizione

  getCriticalAlertsCount: ->
    _(@alerts.alarm).toNumber()

  getWarningAlertsCount: ->
    _(@alerts.warning).toNumber()

  getInfoAlertsCount: ->
    _(@alerts.info).toNumber()

  toSct: ->
    "KEY": @getKey()
    "IMP": @getStatus()
    "DEN": @getName()
    "CRI": @getCriticalAlertsCount()
    "WAR": @getWarningAlertsCount()
    "INF": @getInfoAlertsCount()


class CartographyGateGroupLegacy
  constructor: (@data) ->
    @gateGroup = @data.gateGroup
    @gates = @data.gates

  getLatitude: ->
    _(@gateGroup.latitude).toNumber()

  getLongitude: ->
    _(@gateGroup.longitude).toNumber()

  getKey: ->
    @gateGroup.ID

  getName: ->
    @gateGroup.name

  getSctGates: ->
    _.values(@gates).map (gateData, index) ->
      new CartographyGateLegacy(gateData, index+1).toSct()

  toSct: ->
    "KEY"           : @getKey()
    "x"             : @getLatitude()
    "y"             : @getLongitude()
    "denominazione" : @getName()
    "impianti"      : @getSctGates()

class window.AostaCartographyLegacy extends window.Behavior
  @geoTargheClickExec: (key, alertType) ->
    alertTp = 'info'
    if(alertType == 'CRI')
      alertTp = 'alarm'
    if(alertType == 'WAR')
      alertTp = 'warning'
        
   # alert "Redirigo l'utente su #{key}: #{alertType}"
    $(location).attr "href", settings.baseUrl+"/alert/search?types=#{alertTp}&gates=#{key}"

  init: ->
    @map = $("#big-map")
    @thumbnail = $("#small-map")
    @updateLabel = $("#cartography-update-time")
    @gateGroupsContainer = $("#gate-groups")
    @sct = @map[0].contentWindow
    @attachThumbnailNavigation()

    @POLLING_INTERVAL = 30000

    @map.load =>
      @startPolling()

  attachThumbnailNavigation: ->
    self = @
    defaultZoomLevel = 4
    @thumbnail.click (e) ->
      coords = self.getImageCoords(e, @)
      self.sct.ZoomPunto(coords[0], coords[1], defaultZoomLevel, "UTM-ED50")

  getImageCoords: (event, img) ->
    posX = (if event.offsetX then (event.offsetX) else event.pageX - img.offsetLeft - 848)
    posY = (if event.offsetY then (event.offsetY) else event.pageY - img.offsetTop - 76)
    @sct.pointConvert(posX, posY)

  fetchMapData: ->
    $.ajax
      type: "GET"
      url: settings.baseUrl+"/gatesStatus/gateGroupSummary"

  fetchGateGroupsHtml: ->
    $.ajax
      type: "GET"
      url: settings.baseUrl+"/cartography/viewGateGroups"

  placeMarks: (sctData) ->
    @sct.caricaElementi(sctData)

  refreshTimeLabel: ->
    @updateLabel.html(moment().format('YYYY-MM-DD HH:mm:ss'))

  update: ->
    @updateMap()
    @updateGateGroups()

  updateMap: ->
    @fetchMapData().done (response) =>
      groupsData = JSON.parse(response)
      sctData = _.map groupsData, (groupData) ->
        new CartographyGateGroupLegacy(groupData).toSct()
      @placeMarks(sctData)

  updateGateGroups: ->
    @fetchGateGroupsHtml().done (html) =>
      @gateGroupsContainer.html(html)

  startPolling: ->
    @update()

    setInterval =>
      @update()
      @refreshTimeLabel()
    , @POLLING_INTERVAL


window.geoTargheClickExec = AostaCartographyLegacy.geoTargheClickExec
