#= require ./behavior

class window.DateRangeSetter extends window.Behavior

  init: ->
    @range = @data('daterange-setter-when', 'today')

    @$dom.click =>
      @setRange()

  startDateDom: ->
    @domData('daterange-setter-start-date')
    
  startTimeDom: ->
    @domData('daterange-setter-start-time')
    
  endDateDom: ->
    @domData('daterange-setter-end-date')
    
  endTimeDom: ->
    @domData('daterange-setter-end-time')
    
  checkTime = (i) ->
    i = "0" + i  if i < 10 # add zero in front of numbers < 10
    i

  daysInMonth = (month,year) ->
    new Date(year, month, 0).getDate();

  getDateStringFromDate = (dt) ->
    year  = dt.getFullYear()
    month = dt.getMonth()+1
    day   = dt.getDate()
    str = checkTime(day)+'/'+checkTime(month)+'/'+year
    str
      
  dateAddDays = (dt,days) ->
    msec = dt.getTime()
      
    dhr = days * 24
    dmn = dhr * 60
    dsc = dmn * 60
    dms = dsc * 1000
      
    msec = msec + dms
      
    dt.setTime(msec)      
    dt
      
  setRange: ->
    prova = 10
    behavior = @range

    fromDateCtrl = @startDateDom()
    fromTimeCtrl = @startTimeDom()
         
    toDateCtrl = @endDateDom()
    toTimeCtrl = @endTimeDom()

    # if all ctrls exists
    if(fromDateCtrl.length > 0 && fromTimeCtrl.length > 0 && toDateCtrl.length > 0 && toTimeCtrl.length > 0)
      
      # got today
      today = new Date()

      weekday = today.getDay()
        
      year  = today.getFullYear()
      month = today.getMonth()+1
      day   = today.getDate()
      
      # base vars
      fromYear = year
      toYear = year
      fromMonth = month
      toMonth = month
      fromDay = day
      toDay = day
        
      fromTimeCtrl.val('00:00')	
      toTimeCtrl.val('23:59')

      # # # # behaviors
      
      dateSet = false

      #today
      if behavior == 'today'
        fromDateCtrl.val(checkTime(fromDay)+'/'+checkTime(fromMonth)+'/'+fromYear)
        toDateCtrl.val(checkTime(toDay)+'/'+checkTime(toMonth)+'/'+toYear)
        dateSet = true

      #tomorrow
      if behavior == 'tomorrow'
        fromDay = fromDay + 1
        fromDayLimit = daysInMonth(fromMonth,fromYear)
        if fromDay > fromDayLimit
          fromDay = 1
          fromMonth = fromMonth + 1
        if fromMonth > 12
          fromMonth = 1
          fromYear = fromYear + 1
        
        toDay = fromDay
        toMonth = fromMonth
        toYear = fromYear
        
        fromDateCtrl.val(checkTime(fromDay)+'/'+checkTime(fromMonth)+'/'+fromYear)
        toDateCtrl.val(checkTime(toDay)+'/'+checkTime(toMonth)+'/'+toYear)
        dateSet = true
        
      #thisweek
      if behavior == 'thisweek'          
        startday = dateAddDays(new Date(),-weekday+1)
        endday = dateAddDays(new Date(),6-weekday+1)
        fromDateCtrl.val(getDateStringFromDate(startday))
        toDateCtrl.val(getDateStringFromDate(endday))
        dateSet = true

      #nextweek
      if behavior == 'nextweek'          
        startday = dateAddDays(new Date(),-weekday+1+7)
        endday = dateAddDays(new Date(),6-weekday+1+7)
        fromDateCtrl.val(getDateStringFromDate(startday))
        toDateCtrl.val(getDateStringFromDate(endday))
        dateSet = true

      #thismonth
      if behavior == 'thismonth'          
        endday = daysInMonth(fromMonth,fromYear)
        
        toMonth = fromMonth
        toYear = fromYear
                
        fromDateCtrl.val('01/'+checkTime(fromMonth)+'/'+fromYear)
        toDateCtrl.val(checkTime(endday)+'/'+checkTime(toMonth)+'/'+toYear)
        dateSet = true

      #nextmonth
      if behavior == 'nextmonth'
        fromMonth = fromMonth + 1
        if fromMonth > 12
            fromMonth = 1
            fromYear = fromYear + 1

        endday = daysInMonth(fromMonth,fromYear)
        
        toMonth = fromMonth
        toYear = fromYear
                
        fromDateCtrl.val('01/'+checkTime(fromMonth)+'/'+fromYear)
        toDateCtrl.val(checkTime(endday)+'/'+checkTime(toMonth)+'/'+toYear)
        dateSet = true

      #thisyear
      if behavior == 'thisyear'
        fromDateCtrl.val('01/01/'+year)
        toDateCtrl.val('31/12/'+year)
        dateSet = true

      #nextyear
      if behavior == 'nextyear'
        year = year + 1
        fromDateCtrl.val('01/01/'+year)
        toDateCtrl.val('31/12/'+year)
        dateSet = true

      #always
      if behavior == 'always'
        year = year + 20
        fromDateCtrl.val(checkTime(fromDay)+'/'+checkTime(fromMonth)+'/'+fromYear)
        toDateCtrl.val('31/12/'+year)
        dateSet = true

      if dateSet == false
        #this.indexOf(str) == 0;
        fromDateCtrl.val(checkTime(fromDay)+'/'+checkTime(fromMonth)+'/'+fromYear)
        toDateCtrl.val(behavior)
          
    