#= require ./behavior


class Etalage
  defaultImageWidth: 2500
  defaultImageHeight: 2100

  constructor: (@container, @zoomArea) ->
    @border = 5
    @thumbnailWidth = @container.width() - (2*@border)
    @thumbnailHeight = @thumbnailWidth*3/4
    @zoomWidth = @zoomArea.width()
    @attach()
    @change_callback(1, 'etalage') #direct call for first item on page view

  click_callback: (image_anchor, instance_id) ->
    $window = $(window)
    $modal_image = $("#modal-image")
    $overlay = $("#overlay")
    $zoom_area = $(".etalage_zoom_area").hide()
    $plate = $(".etalage_magnifier").data('plate')
    $image_number = $(".etalage_magnifier").data('image-number')

    windowHeight = $window.height()
    windowWidth = $window.width()

    modalWidth = windowWidth - Math.round(windowWidth/10)
    modalHeight = windowHeight - Math.round(windowHeight/10)
    
    $modal_image.empty().append("<div id='image-container' style='position: relative;'></div>")

    $bigImageWrapper = $("<div id='image-wrapper'></div>")
      .draggable(containment: 'parent')
      .css
        'position' : 'absolute'
        'top'      : 0
        'left'     : 0
        'cursor'   : 'move'

    $("#image-container").append($bigImageWrapper) 

    $bigImage = $("<img src='#{image_anchor}'>")
      .css
        'position' : 'absolute'
        'top'      : 0
        'left'     : 0
        'cursor'   : 'move'
      .load ->

        $image_container = $("#image-container")
        currentWidth = this.width
        currentHeight = this.height

        if currentWidth > modalWidth
          containerWidth = currentWidth * 2 - modalWidth
        else
          modalWidth = currentWidth
          containerWidth = modalWidth

        if currentHeight > modalHeight
          containerHeight = currentHeight * 2 - modalHeight
        else
          modalHeight = currentHeight
          containerHeight = modalHeight

        containerTop = modalHeight/2 - containerHeight/2
        containerLeft =  modalWidth/2 - containerWidth/2

        $image_container.css
          'width'  : containerWidth
          'height' : containerHeight
          'top'    : containerTop
          'left'   : containerLeft
#        .append(this)

        $bigImageWrapper = $("#image-wrapper")
        $bigImageWrapper.append(this)

        $modal_image.css
          'width'  : modalWidth
          'height' : modalHeight
          'top'    : windowHeight/2 - modalHeight/2

        if ($plate)
          rectangle = new Rectangle($plate)
          
          $bigImageWrapper.append(
            new PlateHtml(rectangle).buildDomElement('bigplatedraggable')
             .css
               'border': '1px solid black'
               'background-color': 'red'
               'z-index': 9999
          )
          
          
          imageTop = containerWidth/2 - rectangle.top
          imageLeft = containerHeight/2 - rectangle.left
        else
          imageTop = containerWidth/2 - currentWidth/2
          imageLeft = containerHeight/2 - currentHeight/2
          
        
        $(".thumb_"+$image_number+" .extra-area").each (index, element) =>
          
          area = $(element)
     
          rectangle = new Rectangle(area)
          
          $bigImageWrapper.append(
            new PlateHtml(rectangle).buildDomElement('bigareadraggable').css
             'border': '1px solid'
             'border-color': area.data('border-color')
             'z-index': 9999
          )       
          

        $bigImageWrapper.css
          'top' : imageTop
          'left' : imageLeft

        $overlay.fadeIn()

    $overlay.click ->
      $(this).fadeOut()

    false

  change_callback: (image_number, instance_id) =>
    zoom_area = $(".etalage_zoom_area").children(":last")

    plate = $(".thumb_"+image_number+" > .plate")
    zoom_area = $(".etalage_zoom_area").children(":last")
    zoom_area.find('.bigplate').remove()

    if (plate.length > 0)
      rectangle = new Rectangle(plate).changeProportions(
        @defaultImageWidth/plate.data('image-width'),
        @defaultImageHeight/plate.data('image-height')
      )

      $('.etalage_magnifier').data
        'plate': plate
        'plate-left': rectangle.left
        'plate-top': rectangle.top
        
      zoom_area.append(
        new PlateHtml(rectangle).buildDomElement('bigplate')
          .css
            'border': '2px solid red'
            'z-index': 9999
      )

    zoom_area = $(".etalage_zoom_area").children(":last")
    zoom_area.find('.bigarea').remove()
    
    $('.etalage_magnifier').data
      'image-number': image_number

    $(".thumb_"+image_number+" .extra-area").each (index, element) =>
    
      area = $(element)
 
      rectangle = new Rectangle(area).changeProportions(
        @defaultImageWidth/area.data('image-width'),
        @defaultImageHeight/area.data('image-height')
      )
      
      zoom_area = $(".etalage_zoom_area").children(":last")
      
      areaRect = new PlateHtml(rectangle).buildDomElement('bigarea')
      areaRect.css
            'border': '2px solid'
            'z-index': 9999
            'border-color': area.data('border-color')
      areaRect.data
            'zoom-left': rectangle.left
            'zoom-top': rectangle.top
               
      zoom_area.append(areaRect)


  attach: ->
    @container.find('#etalage').etalage
      source_image_width: @defaultImageWidth
      source_image_height: @defaultImageHeight
      thumb_image_width:  @thumbnailWidth
      thumb_image_height: @thumbnailHeight
      zoom_area_width: @zoomWidth
      autoplay: false
      zoom_easing: false
      show_hint: false
      click_callback: @click_callback
      change_callback: @change_callback

class Rectangle
  constructor: (domElement) ->
    @top    = domElement.data('rect-top')
    @left   = domElement.data('rect-left')
    @height = domElement.data('rect-height')
    @width  = domElement.data('rect-width')

  changeProportions: (widthPercentage, heightPercentage) ->
    @top    = Math.round(@top    * heightPercentage)
    @left   = Math.round(@left   * widthPercentage)
    @height = Math.round(@height * heightPercentage)
    @width  = Math.round(@width  * widthPercentage)
    this

class PlateHtml
  constructor: (@rectangle) ->

  buildDomElement: (className, padding = 0) ->
    $("<div>")
      .attr('class', className)
      .css
        display: "block"
        position: "absolute"
        top: (@rectangle.top - padding)
        left: (@rectangle.left - padding)
        height: @rectangle.height + (2*padding)
        width: @rectangle.width + (2*padding)
        border: "1px solid red"
        'border-radius': '4px'


class window.MediaEtalage extends window.Behavior

  init: ->

    etalage = new Etalage($('#etalage-container'), $('#event-data'))

    $('#etalage').mousemove ->
      $magnifier = $('.etalage_magnifier')
      img = $('.etalage_zoom_img')
      $('.bigplate').css
        'left': parseInt(img.css('left')) + $magnifier.data('plate-left')
        'top': parseInt(img.css('top')) + $magnifier.data('plate-top')
      $('.bigarea').each ->
        area = $(this)
        area.css
          'left': parseInt(img.css('left')) + area.data('zoom-left')
          'top': parseInt(img.css('top')) + area.data('zoom-top')
        
    $(".plate").each ->
      plate = $(this)
      rectangle = new Rectangle(plate)
      rectangle.changeProportions(
        etalage.thumbnailWidth/plate.data('image-width'),
        etalage.thumbnailHeight/plate.data('image-height')
      )
      
      rectangle.top  = rectangle.top  + etalage.border
      rectangle.left = rectangle.left + etalage.border
      
      smallPlate = new PlateHtml(rectangle).buildDomElement('smallplate', 6).css(
        'z-index': 9999
      )
      smallPlate.insertAfter(plate)

    $(".extra-area").each ->
      extraArea = $(this)
      rectangle = new Rectangle(extraArea)
      
      rectangle.changeProportions(
        etalage.thumbnailWidth/extraArea.data('image-width'),
        etalage.thumbnailHeight/extraArea.data('image-height')
      )
      rectangle.top  = rectangle.top  + etalage.border
      rectangle.left = rectangle.left + etalage.border
      
      smallArea = new PlateHtml(rectangle).buildDomElement('small-extra-area', 0).css(
        'background-color': 'transparent'
        'border': '1px solid'
        'border-color': extraArea.data('border-color') 
        'z-index': 9999
      )
      smallArea.insertAfter(extraArea)
