#= require ./behavior
#= require ./mixins/refreshViolationPreviewTable

class window.ViolationsPreview extends window.Behavior
  @include window.RefreshViolationPreviewTable

  init: ->
    @$violationsContainer = @$dom
    @$dom.on 'click', '.update-violations-preview', =>
      @refreshViolationsTable(@getGateId())
    @autoUpdate()

  autoUpdate: ->
    setInterval(
      =>
        if @shouldAutoUpdate()
          @refreshViolationsTable(@getGateId())
      , 5000
    )

  getGateId: ->
    @data('gate-id')

  shouldAutoUpdate: ->
    @$dom.find('.automatic-violations-preview').is(':checked')
