$ ->

  opts =
    lines: 13
    length: 7
    width: 4
    radius: 10
    corners: 1 
    rotate: 0
    color: '#000'
    speed: 1
    trail: 60
    shadow: false
    hwaccel: false
    className: 'spinner'
    zIndex: 2e9
    top: 5
    left: 'auto'

  if ($('#search-page').length > 0)

    $('.date-picker').datepicker()

    $(".icon-calendar").click ->
      $(@).siblings('.date-picker').datepicker('show')

    delay = (->
      timer = 0
      (callback, ms) ->
        clearTimeout timer
        timer = setTimeout(callback, ms)
    )()

    findEvents = ->
      if document.searchParameters.query.length > -1
        spinner = new Spinner(opts).spin($("#spinner").get(0))
        $.ajax
          type: "GET"
          url: settings.baseUrl+"/search/find"
          data: $.param(document.searchParameters)
          success: (html) ->
            spinner.stop()
            $("#find-results").html(html)
          error: (message) ->
            spinner.stop()

     

    setupDatePickers = ->
      $(".date-picker").change ->
        $("#when-buttons button").removeClass('active')
        document.searchParameters.startTimestamp = moment($("#start-date").datepicker('getDate')).startOf("day").unix()
        document.searchParameters.endTimestamp = moment($("#end-date").datepicker('getDate')).endOf("day").unix()
        findEvents()

    toggleMonth = ->
      document.searchParameters.startTimestamp = moment().subtract('months', 1).startOf('day').unix()
      document.searchParameters.endTimestamp = moment().endOf('day').unix()
      refreshDateFields()
      
    toggle2Month = ->
      document.searchParameters.startTimestamp = moment().subtract('months', 2).startOf('day').unix()
      document.searchParameters.endTimestamp = moment().endOf('day').unix()
      refreshDateFields()
      
    toggle3Month = ->
      document.searchParameters.startTimestamp = moment().subtract('months', 3).startOf('day').unix()
      document.searchParameters.endTimestamp = moment().endOf('day').unix()
      refreshDateFields()
      
    toggle3years = ->
      document.searchParameters.startTimestamp = moment().subtract('years', 3).startOf('day').unix()
      document.searchParameters.endTimestamp = moment().endOf('day').unix()
      refreshDateFields()

    toggleWeek = ->
      document.searchParameters.startTimestamp = moment().subtract('weeks', 1).startOf('day').unix()
      document.searchParameters.endTimestamp = moment().endOf('day').unix()
      refreshDateFields()

    refreshDateFields = ->
      $("#start-date").datepicker('setDate', moment.unix(document.searchParameters.startTimestamp).toDate())
      $("#end-date").datepicker('setDate', moment.unix(document.searchParameters.endTimestamp).toDate())
      findEvents()

    document.searchParameters =
      startTimestamp: 0
      endTimestamp: 0
      query: ""

    setupDatePickers()

    $("#this-threeyears-button").button('toggle')
    toggle3years()

    $("#this-week-button").click ->
      toggleWeek()

    $("#this-monthtwo-button").click ->
      toggle2Month()

    $("#this-monththree-button").click ->
      toggle3Month()
      
    $("#this-threeyears-button").click ->
      toggle3years()
   
    $("#searchbar").keypress (e) ->
      if (e.keyCode == 13)
        e.preventDefault()
        return false
      true

    $("#searchbar").keyup (e) ->
      if (e.keyCode == 13) 
        return false
      searchbar = $(this)
      delay (->
        document.searchParameters.query = searchbar.val()
        findEvents()
      ), 500

    $("#searchbar").focus()
