<?php

require_once 'globals.php';


class cryptPlateCommand extends CConsoleCommand
{
	const CPC_NONE 		= 0;
	const CPC_ENCRYPT 	= 1;
	const CPC_DECRYPT 	= 2;
	
	
	public function criptPlatesInVehicleTrace($criptMode, $gates, $startDatetime, $endDatetime, $fileName, $bUpdateDB)
	{
		$scrumbler = new PlateScrumble();
		$scrumbler->Init('KRIAScrambleKey');
		
		$offset = 0;

		$dbCriteria = new CDbCriteria();
		if($startDatetime != null)
		{
			echo "\n - start DateTime $startDatetime";
			$dbCriteria->addCondition("StartDateTime >= '".$startDatetime."'");
		}
		
		if($endDatetime != null)
		{
			echo "\n - end DateTime $endDatetime";
			$dbCriteria->addCondition("StartDateTime <= '". $endDatetime."'");
		}
		
		
		if($gates != null)
		{
			echo "\n - gates $gates";
			$dbCriteria->addInCondition('GateID', $gates);
		}
		
		$file = null;
		
		if($fileName != null)
		{
			echo "\n - open file $fileName";
			$file = fopen($fileName, w);
		
			if($file == null)
				return FALSE;
		}
		
		
		do 
		{
			echo "\n start";
			
			$dbCriteria->limit = 100;
			$dbCriteria->offset = $offset;
			$dbCriteria->order= 'StartDateTime ASC';
			
			$resPlate = VehicleTrace::model()->findAll($dbCriteria);
			
			$count = count($resPlate);
			
			if($count <= 0)
				break;
			
			$offset += $count;
				
			if($criptMode == self::CPC_ENCRYPT)
				echo "\n Encrypt Plates: ".$count." / ".$offset;
			else if($criptMode == self::CPC_DECRYPT)
				echo "\n Decrypt Plates: ".$count." / ".$offset;
			else
				echo "\n Export Plates: ".$count." / ".$offset;
			
			foreach($resPlate as $vt)
			{
				$plate = $vt->VehicleID;
				
				
				if($criptMode == self::CPC_ENCRYPT)
					$plate = $scrumbler->Crypt($plate);
				else if($criptMode == self::CPC_DECRYPT)
					$plate = $scrumbler->DeCrypt($plate);
								
				$plateLog = sprintf("%010d", $vt->ID).';'.$vt->StartDateTime->format('d/m/Y').";".$vt->StartDateTime->format('H:i:s').";".$vt->GateID.";".$vt->Direction.";".$vt->NetworkID.";".$plate.";".$vt->BlobFileNameBN;
				 
				if($file != null)
					fwrite($file, "\n".$plateLog);
				else
					echo "\n$plateLog";
				
				if($bUpdateDB)
				{
					$vt->VehicleID = $plate;
					if(!$vt->save(false))
						echo "\n cannot save";
				} 

				if($file != null)
					echo "."; 
				 
				
			}
		}
		while($count >= 0);
		
		if($file != null)
			fclose($file);
	}
		
	
	public function run($args)
	{
		echo hello;

		var_dump($args);
		
		echo "\n######################################################################";
		echo "\n##                                                                  ##";
		echo "\n##                    ENCRYPT/DECRIPT PLATES                        ##";
		echo "\n##                                                                  ##";
		echo "\n######################################################################";
		echo "\n";
		echo "\n";
		

		echo count($args) ;
		echo array_search('/?', $args) ;
		
		if(count($args) <= 0 || array_search('/?', $args) != FALSE || array_search('-?', $args) != FALSE)
		{
			
			if(count($args) <= 0)
				echo "\n Please specify one or more arguments!";
			
			echo "\n";
			echo "\n -encrypt                           encrypt plates";
			echo "\n -decrypt                           decrypt plates";
			echo "\n -startDateTime                     start date/time format YYY-MM-DD HH:MM:SS";
			echo "\n -endDateTime                       end date/time format YYY-MM-DD HH:MM:SS";
			echo "\n -gates                             gate id separated by ,";
			echo "\n -fileName                          fileName For export";
			echo "\n -updateDB                          update plate field";
				
				
			echo "\n";
			echo "\n";
				
			
			return 0;
		}
		
					
		$encryptMode 		= null;
		$startDateTime 		= null;
		$endDateTime 		= null;
		$gates 				= null;
		$fileName 			= null;
		$bUpdateDB			= false;
					
		$encryptMode = self::CPC_NONE;
		
		if(array_search('-encrypt', $args) !==  false)
			$encryptMode = self::CPC_ENCRYPT;
		else if(array_search('-decrypt', $args) !==  false)
			$encryptMode = self::CPC_DECRYPT;
		
		$pos = array_search('-startDateTime', $args);
		if($pos !==  false)
			$startDateTime = $args[$pos+1];
		
		$pos = array_search('-endDateTime', $args);
		if($pos !==  false)
			$endDateTime = $args[$pos+1];
		
		$pos = array_search('-gates', $args);
		if($pos !==  false)
		{
			$gatesParam = $args[$pos+1];
			$gates = explode(',', $args[$pos+1]);
		}
		

		$pos = array_search('-fileName', $args);
		if($pos !==  false)
			$fileName = $args[$pos+1];
		
		if(array_search('-updateDB', $args) !==  false)
			$bUpdateDB			= true;
		
		echo "\n Encrypt mode           = $encryptMode";
		echo "\n Start date/time        = $startDateTime";
		echo "\n End date/time          = $endtDateTime";
		echo "\n Gates                  = $gatesParam";
		echo "\n Filename               = $fileName";
		echo "\n updateDB               = $bUpdateDB";
		
		
		
		echo "\n##################################################################";
		echo "\n Export Plates";
		echo "\n##################################################################";
		
		self::criptPlatesInVehicleTrace($encryptMode, $gates, $startDateTime, $endDateTime, $fileName, $bUpdateDB);
		
		echo "\n done";

		
		return 0;
		
	}
	
}
?>