<?php

/**
 * 
 * @author p6
 *
 */
class CStack
{
  protected $_stack;
  
  /**
   * 
   * @param Array $array
   */
  public function __construct($array = array())
  {
    $this->_stack = $array;
  }

  /**
   * 
   * @return NULL|mixed
   */
  public function head()
  {
    return $this->getItem($this->count()-1);
  }
    
  /**
   * 
   * @param number $index
   * @return NULL|mixed
   */
  public function getItem($index)
  {
    if($index < 0 || $index >= $this->count())
      return null;
    return $this->_stack[$index];
  }
  
   /**
   * 
   * @param number $index
   * @param mixed $value
   */
  public function setItem($index,$value)
  {
    if($index >= 0 && $index < $this->count())
      $this->_stack[$index] = $value;
  }
  
  /**
   * 
   * @param mixed $item
   */
  public function push($item)
  {
    array_push($this->_stack, $item);
  }
  
  /**
   * 
   * @return NULL|mixed
   */
  public function pop()
  {
    if(!$this->hasItems())
      return null;
    return array_pop($this->_stack);
  }
  
  /**
   * 
   * @return boolean
   */
  public function hasItems()
  {
    return $this->count() > 0;
  }
  
  /**
   * 
   * @return number
   */
  public function count()
  {
    return count($this->_stack);
  }
}
