<?php

class PlateAuthInfoImportExportData extends Object
{
  /**
   * list of plate authorizations
   * @var array
   */
  public $vehicleOwners = array();
  /**
   * list of vehicles
   * @var array
  */
  public $vehicles = array();
  /**
   * list of validity periods
   * @var array
  */
  public $validityPeriods = array();
  /**
   * list of plate authorizations
   * @var array
  */
  public $plateAuthorizations = array();
  /**
   * plate authorization list
   * @var array
   */
  public $plateLists = array();
  
  /**
   * @return PlateAuthInfoImportExportData
  */
  public static function deserialize($data,$strict=true)
  {
    return parent::deserialize($data,$strict);
  }

  /**
   * 
   * @param PlateAuthorization|Vehicle|VehicleOwner|ValidityPeriod|PlateList $obj
   * @return boolean
   */
  public function add($obj)
  {
    if($obj === null)
    {
      return false;
    }
    
    if(is_array_ex($obj))
    {
      foreach($obj as $item)
        if(!$this->add($item))
          return false;
      return true;
    }

    if($obj instanceof PlateList)
    {
      $this->plateLists[intval($obj->id)] = $obj->attributes;
      return true;
    }

    if($obj instanceof PlateAuthorization)
    {
      $this->plateAuthorizations[intval($obj->ID)] = $obj->attributes;
      return true;
    }
    
    if($obj instanceof Vehicle)
    {
      $this->vehicles[intval($obj->ID)] = $obj->attributes;
      return true;
    }

    if($obj instanceof VehicleOwner)
    {
      $this->vehicleOwners[intval($obj->ID)] = $obj->attributes;
      return true;
    }

    if($obj instanceof ValidityPeriod)
    {
      $this->validityPeriods[intval($obj->ID)] = $obj->attributes;
      return true;
    }

    return false;
  }
}
