<?php

return array(
  'yiiDebug' => true,
  'yiiTraceLevel' => 3,

  'configWeb' => array(
    'modules'=>array(
      'gii'=>array(
        'class'=>'system.gii.GiiModule',
        'password'=>kria_load_secret('gii'),
        'ipFilters'=>array('127.0.0.1','::1'),
        'generatorPaths'=>array(
          'bootstrap.gii',
        ),
      ),
    ),
    'components' => array(
      'db'=>array(
        'connectionString' => 'mysql:host=127.0.0.1;dbname=eventserverdb',
        'emulatePrepare' => true,
        'username' => 'kria',
        'password' => kria_load_secret('db'),
        'charset' => 'utf8',
        'tablePrefix' => '',
        'enableProfiling'=>true,
        'enableParamLogging'=>true,
      ),
    ),
    'params' => array(
      'photoBaseUrl' => '/kria-photos',
      'photoBasePath' => 'D:\mysql\data',

    		'log4php' => array(
    				'rootLogger' => array(
    						'appenders' => array('socket'),
    				),
    				'eventserver-gui' => array(
    						'appenders' => array(), // see main for log enabling
    				),
    				'appenders' => array(
    						'default' => array(
    								'class' => 'LoggerAppenderFile',
    								'layout' => array(
    										'class' => 'LoggerLayoutSimple'
    								),
    								'params' => array(
    										'file' => 'c:/testlog4php.log',
    										'append' => true
    								)
    						),
    						'socket' => array(
    								'class' => 'LoggerAppenderSocket',
    								'layout' => array(
    										'class' => 'LoggerLayoutPattern',
    										'params' => array(
    												'conversionPattern' => '%date %logger %-5level %msg%n',
    										)
    								),
    								'params' => array(
    										'remoteHost' => '127.0.0.1',
    										'port' => 6101
    								)
    						),
    						'syslog' => array(
    								'class' => 'LoggerAppenderSyslog',
    								'layout' => array(
    										'class' => 'LoggerLayoutSimple',
    								),
    								'params' => array(
    										'ident' => 'eventserver-gui',
    										'facility' => 'USER',
    										'option'	 => 'NDELAY|PID',
    								)
    						),
    				)
    		),    		
    		
    ),
  ),
);
