<?php

class ExportRegistrationReportController extends Controller
{
  public $layout = '//layouts/print';

  protected function beforeAction($event)
  {
    //access_denied_check ( "export_history_report" );
    return parent::beforeAction ( $event );
  }

  /**
   *
   * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
   *      using two-column layout. See 'protected/views/layouts/column2.php'.
   */

  

  /**
   * Displays a particular model.
   *
   * @param integer $id
   *          the ID of the model to be displayedSectionController.php
   */
 

  public function actionServerFinalReport($idServer, $year, $month, $gate)
  {
  	$layout = '//layouts/print';
  	
  	$startT = new Datetime();
  	
  	$startT->setDate($year, $month, 1);
  	$startT->setTime(0, 0, 0);
  	
  	$endT = clone $startT;
  	
  	if($month < 12)
	  	$endT->setDate($year, $month+1, 1);
  	else
  		$endT->setDate($year+1, 1, 1);
  	

  	$endT->setTime(0, 0, 0);
  	
  	
  	$eventServer =  EventServerRegistration::model()->byId($idServer)->find();
  	
 
  	if($gate >= 0)
  	{
	
  		$exportedEvents = ExportedEvents::model()->byServer($idServer)->byGate($gate)->byInterval($startT, $endT)->findAll();  
  	}
  	else
  	{
  		$exportedEvents = ExportedEvents::model()->byServer($idServer)->byInterval($startT, $endT)->findAll();
  	}
  	
  	
  	$numOfExported = 0;
  	$numOfDeletes = 0;
  	
  	foreach($exportedEvents as $expEvent)
  	{
  		$numOfExported += $expEvent->exported_events;
  		$numOfDeletes += $expEvent->deleted_events;
  	}
  	
  	$endT = $endT->sub(new DateInterval('P1D'));
  	$endT->setTime(23, 59, 59);
  	
 	
  	$this->render ('create', array('eventServerName' => $evenServer->name, 'eventServer' => $eventServer, 'startDate' => $startT, 'endDate' => $endT, 'exportedEvents' => $exportedEvents, 'numOfExported' => $numOfExported, 'numOfDeletes' => $numOfDeletes, 'gate'=> $gate));
  	
  }
}
