<?php

class ZtlEditorController extends Controller
{

  /**
   *
   * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
   *      using two-column layout. See 'protected/views/layouts/column2.php'.
   */
  public $layout = '//layouts/column2';

  protected function beforeAction($event)
  {
    access_denied_check ( 'ztl_edit' );
    return parent::beforeAction ( $event );
  }

  /**
   * Displays a particular model.
   * 
   * @param integer $id
   *          the ID of the model to be displayed
   */
  public function actionView($id)
  {
    $this->render ( 'view', array (
        'model' => $this->loadModel ( $id ) 
    ) );
  }

  /**
   * Creates a new model.
   * If creation is successful, the browser will be redirected to the 'view' page.
   */
  public function actionCreate()
  {
    $model = new Ztl ();
    
    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);
    
    if (isset ( $_POST ['Ztl'] ))
    {
      $_POST ['Ztl'] ['epoch'] = DateHelper::ensureObjectEx ()->toDateTimeString ();
      $model->attributes = $_POST ['Ztl'];
      if ($model->save ())
        $this->redirect ( array (
            'view',
            'id' => $model->ID 
        ) );
    }
    
    $this->render ( 'create', array (
        'model' => $model 
    ) );
  }

  /**
   * Updates a particular model.
   * If update is successful, the browser will be redirected to the 'view' page.
   * 
   * @param integer $id
   *          the ID of the model to be updated
   */
  public function actionUpdate($id)
  {
    $model = $this->loadModel ( $id );
    
    // Uncomment the following line if AJAX validation is needed
    // $this->performAjaxValidation($model);
    
    if (isset ( $_POST ['Ztl'] ))
    {
      $_POST ['Ztl'] ['epoch'] = DateHelper::ensureObjectEx ()->toDateTimeString ();
      $model->attributes = $_POST ['Ztl'];
      if ($model->save ())
        $this->redirect ( array (
            'view',
            'id' => $model->ID 
        ) );
    }
    
    $this->render ( 'update', array (
        'model' => $model 
    ) );
  }

  /**
   * Deletes a particular model.
   * If deletion is successful, the browser will be redirected to the 'admin' page.
   * 
   * @param integer $id
   *          the ID of the model to be deleted
   */
  public function actionDelete($id)
  {
    $this->loadModel ( $id )
      ->delete ();
    if (! isset ( $_REQUEST ['ajax'] ))
      $this->redirect ( isset ( $_REQUEST ['returnUrl'] ) ? $_REQUEST ['returnUrl'] : array (
          'admin' 
      ) );
  }

  /**
   * Lists all models.
   */
  public function actionIndex()
  {
    $dataProvider = new CActiveDataProvider ( 'Ztl' );
    $this->render ( 'index', array (
        'dataProvider' => $dataProvider 
    ) );
  }

  /**
   * Manages all models.
   */
  public function actionAdmin()
  {
    $model = new Ztl ( 'search' );
    $model->unsetAttributes (); // clear any default values
    if (isset ( $_GET ['Ztl'] ))
      $model->attributes = $_GET ['Ztl'];
    
    $this->render ( 'admin', array (
        'model' => $model 
    ) );
  }

  /**
   * Returns the data model based on the primary key given in the GET variable.
   * If the data model is not found, an HTTP exception will be raised.
   * 
   * @param
   *          integer the ID of the model to be loaded
   */
  public function loadModel($id)
  {
    $model = Ztl::model ()->findByPk ( $id );
    if ($model === null)
      throw new CHttpException ( 404, 'The requested page does not exist.' );
    return $model;
  }

  /**
   * Performs the AJAX validation.
   * 
   * @param
   *          CModel the model to be validated
   */
  protected function performAjaxValidation($model)
  {
    if (isset ( $_POST ['ajax'] ) && $_POST ['ajax'] === 'ztl-form')
    {
      echo CActiveForm::validate ( $model );
      Yii::app ()->end ();
    }
  }
}
