<?php

/*
 * <select id="granularity" name="granularity">
 * <option value="300">5 Minuti</option>
 * <option value="600">10 Minuti</option>
 * <option value="1800">30 Minuti</option>
 * <option value="3600">1 ora</option>
 * <option value="7200">2 ore</option>
 * <option value="86400">1 giorno</option>
 * <option value="604800">1 settimana solare</option>
 * <option value="2592000">1 mese solare</option>
 * </select>
 *
 */
class HtmlHelper
{

  public static function createForm($fields, $action = null, $method = null, $formOptions = null)
  {
    $fieldsHtml = "";
    $unnamed = 0;
    
    $haveSubmit = false;
    $haveFiles = false;
    $haveMaxFileSize = false;
    
    foreach ( $fields as $field )
    {
      $field = new CArray ( ( array ) $field );
      
      $tag = onNull ( $field->tag, "input" );
      $closeTag = onNull ( $field->close, true, true );
      $content = $field->content;
      
      $type = onNull ( $field->type, "text" );
      $name = onNull ( $field->name, "unnamed_" . $unnamed ++ );
      $value = $field->value;
      
      if ($type == "submit")
        $haveSubmit = true;
      
      if ($type == "file")
        $haveFiles = true;
      
      if ($name == "MAX_FILE_SIZE")
        $haveMaxFileSize = true;
      
      $options = $field->options;
      if ($options == null || ! is_array ( $options ))
        $options = array ();
      
      $options ['type'] = $type;
      $options ['name'] = $name;
      $options ['value'] = $value;
      
      if ($type != "hidden" || $field->forcePS === true)
      {
        $label = $type == 'radio' ? $value : $name;
        $prefix = onNull ( $field->prefix, createBeautifulString ( $label ) . ": ", true );
        $suffix = onNull ( $field->suffix, "<br />", true );
      }
      else
      {
        $prefix = "";
        $suffix = "";
      }
      
      $fieldsHtml .= $prefix . CHtml::tag ( $tag, $options, $content, $closeTag ) . $suffix;
    }
    
    if ($formOptions == null || ! is_array ( $formOptions ))
      $formOptions = array ();
    
    if ($haveFiles)
    {
      $formOptions ["enctype"] = "multipart/form-data";
    }
    
    if (! $haveSubmit)
    {
      $fieldsHtml .= CHtml::submitButton ();
    }
    
    if (! empty ( $action ))
      $formOptions ["action"] = $action;
    if (! empty ( $method ))
      $formOptions ["method"] = $method;
    
    return CHtml::tag ( 'form', $formOptions, $fieldsHtml, true );
  }

  public static function createSelect($id, $name, $array, $selected, $options)
  {
    $attributes = "";
    foreach ( $options as $key => $value )
    {
      $attributes .= " $key=\"$value\"";
    }
    
    $html = "<select id=\"$id\" name=\"$name\" $attributes>";
    foreach ( $array as $key => $value )
    {
      $html .= "<option value=\"$key\">$value</option>";
    }
    $html .= "</select>";
    
    return $html;
  }

  public static function img($url, $alt, $params)
  {
    return CHtml::image ( $url, null, $params );
  }

  public static function printTree($array, $level = 0)
  {
    $value = NULL;
    if ($array === NULL)
      $value = "<i>NULL</i>";
    else
    {
      $value = "dikdk";
    }
    return $level > 0 ? "<li>$value</li>" : $value;
  }

  public static function hiddenData(array $data)
  {
    $html = "";
    foreach ( $data as $key => $value )
      $html .= CHtml::hiddenField ( $key, $value );
    return $html;
  }

  public static function textRow($name, $value = '', array $options = array(), $id = null, $label = null)
  {
    if ($id == null)
      $id = "field_" . $name . "_" . rand_str ( "123456789", 6 );
    if ($label == null)
      $label = ucwords ( $name );
    return CHtml::label ( $label, $id ) . ' ' . CHtml::textField ( $name, $value, $options );
  }

  public static function dropDownRow($name, array $data, $value = '', array $options = array(), $id = null, $label = null)
  {
    if ($id == null)
      $id = "field_" . $name . "_" . rand_str ( "123456789", 6 );
    if ($label == null)
      $label = ucwords ( $name );
    return CHtml::label ( $label, $id ) . ' ' . CHtml::dropDownList ( $name, $value, $data, $options );
  }
}
