<?php
class ImageAreaHelper
{
  static public function getAreaColor($type)
  {
    switch($type)
    {
      case 'extended_plate_area':
        return 'red';
      case 'sub_vehicle_plates':
        return 'yellow';
      case 'other_plates':
        return 'blue';
      case 'vehicle_driver_face':
        return 'green';
      case 'additional_areas':
        return 'orange';
    }
    return 'grey';
  }

  /**
   *
   * @param string $type extended_plate_area|sub_vehicle_plates|other_plates|vehicle_driver_face|additional_areas|....
   * @return array(R,G,B)
   */
  static public function getAreaColorRGB($type)
  {
    switch($type)
    {
      case 'extended_plate_area':
        return array('R'=>255,'G'=>0,'B'=>0);
      case 'sub_vehicle_plates':
        return array('R'=>255,'G'=>255,'B'=>0);
      case 'other_plates':
        return array('R'=>0,'G'=>0,'B'=>255);
      case 'vehicle_driver_face':
        return array('R'=>0,'G'=>255,'B'=>0);
      case 'additional_areas':
        return array('R'=>255,'G'=>165,'B'=>0);
    }
    return array('R'=>128,'G'=>128,'B'=>128);
  }
}