<?php

class m131003_060904_live_bookmark_and_more extends MyDbMigration
{
	public function up()
	{
		if ($this->dbConnection->schema->getTable('gatetable')->getColumn('live_url') == null)
			$this->addColumn('gatetable', 'live_url', 'string');
		
		if ($this->dbConnection->schema->getTable('vehicletracetable')->getColumn('plate_to_be_checked') == null)
			$this->addColumn('vehicletracetable', 'plate_to_be_checked', 'boolean');

		if ($this->dbConnection->schema->getTable('event_reporting')->getColumn('just_modified') == null)
			$this->addColumn('event_reporting', 'just_modified', 'boolean');
		
		$this->execute(
				"CREATE TABLE IF NOT EXISTS `bookmark` (
			        `id` int(11) NOT NULL AUTO_INCREMENT,
			        `id_user` int(11) NOT NULL,
			        `id_reference` int(11) NOT NULL,
			        `type` varchar(255),
			        `epoch` datetime NOT NULL,
			        PRIMARY KEY (`id`)
			  ) ENGINE=MyISAM  DEFAULT CHARSET=utf8"
		);
		
		try { $this->createIndex('plate_to_be_checked_index', 'vehicletracetable', 'plate_to_be_checked'); } catch (Exception $e) {}
		try { $this->createIndex('just_modified_index', 'event_reporting', 'just_modified'); } catch (Exception $e) {}
	}

	public function down()
	{
		if ($this->dbConnection->schema->getTable('gatetable')->getColumn('live_url') != null)
			$this->dropColumn('gatetable', 'live_url');
		
		if ($this->dbConnection->schema->getTable('vehicletracetable')->getColumn('plate_to_be_checked') != null)
			$this->dropColumn('vehicletracetable', 'plate_to_be_checked');
		
		if ($this->dbConnection->schema->getTable('event_reporting')->getColumn('just_modified') != null)
			$this->dropColumn('event_reporting', 'just_modified');
		
		if ($this->dbConnection->schema->getTable('bookmark') != null)
			$this->dropTable('bookmark');
		
		try { $this->dropIndex('plate_to_be_checked_index', 'vehicletracetable'); } catch (Exception $e) {}
		try { $this->dropIndex('just_modified_index', 'event_reporting'); } catch (Exception $e) {}
		
		return true;
	}

	/*
	// Use safeUp/safeDown to do migration with transaction
	public function safeUp()
	{
	}

	public function safeDown()
	{
	}
	*/
}