<?php

class m160613_120331_create_crossing_times_table extends MyDbMigration
{

  public function up()
  {
    $this->createTableIfNotExists ( "crossing_times" );
    $this->addColumn ( "crossing_times", "timestamp", "DATETIME NOT NULL" ); // al momento dell'inserimento
    $this->addColumn ( "crossing_times", "range", "REAL" ); // al momento dell'inserimento, in ore totali, non obbligatorio (NULL=default da sw)
    $this->addColumn ( "crossing_times", "id_gate_start", "BIGINT NOT NULL" ); // al momento dell'inserimento
    $this->addColumn ( "crossing_times", "id_gate_end", "BIGINT NOT NULL" ); // al momento dell'inserimento
    $this->addColumn ( "crossing_times", "ref_section", "BIGINT" ); // assegnata dal software t-section, non obbligatorio
    $this->addColumn ( "crossing_times", "duration_avg", "REAL" ); // assegnata dal software t-section, in ore totali, non obbligatorio
    $this->addColumn ( "crossing_times", "duration_stddev", "REAL" ); // assegnata dal software t-section, in ore totali, non obbligatorio
    $this->addColumn ( "crossing_times", "duration_min", "REAL" ); // assegnata dal software t-section, in ore totali, non obbligatorio
    $this->addColumn ( "crossing_times", "duration_max", "REAL" ); // assegnata dal software t-section, in ore totali, non obbligatorio
    $this->addColumn ( "crossing_times", "duration_count", "REAL" ); // assegnata dal software t-section, in ore totali, non obbligatorio
    $this->addColumn ( "crossing_times", "done", "BIT NOT NULL" ); // assegnata dal software t-section, flag che dice se è stato elaborato o meno
    $this->addColumn ( "crossing_times", "result_code", "BIGINT NOT NULL" ); // assegnata dal software t-section, eventule codice di errore
    $this->addColumn ( "crossing_times", "result_message", "VARCHAR(256)" ); // assegnata dal software t-section, eventuale messaggio di errore
    $this->addColumn ( "crossing_times", "source", "VARCHAR(256)" ); // assegnata dal software t-section, fonte dei dati (eveserver, google, altri servizi)
  }

  public function down()
  {
    $this->dropTableIfExists ( 'crossing_times' );
    return true;
  }
}
    