<?php

/**
 * This is the model class for table "gate_set_matrix".
 *
 * The followings are the available columns in table 'gate_set_matrix':
 * @property integer $id
 * @property string $epoch
 * @property integer $gate
 * @property integer $set
 */
class GateSetMatrix extends ActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return GateSetMatrix the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'gate_set_matrix';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('gate, set', 'required'),
			array('gate, set', 'numerical', 'integerOnly'=>true),
			array('epoch', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, epoch, gate, set', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function myAttributeLabels()
	{
		return array(
			'id' => 'ID',
			'epoch' => 'Epoch',
			'gate' => 'Gate',
			'set' => 'Set',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('epoch',$this->epoch,true);
		$criteria->compare('gate',$this->gate);
		$criteria->compare('set',$this->set);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}