<?php

class Kemler extends CComponent
{
  private $kemlerCode;

  public function __construct($kemlerCode)
  {
    $this->kemlerCode = $kemlerCode;
  }

  public function getAdr()
  {
    $code = $this->extractAdrCode();
    if (isset($code))
      return AdrCode::model()->byCode($code)->find();
  }

  public function getOnu()
  {
    $code = $this->extractOnuCode();
    if (isset($code))
      return OnuCode::model()->byCode($code)->find();
  }

  private function extractAdrCode()
  {
    $pieces = explode('-', $this->kemlerCode);
    if (count($pieces)==2)
      return $pieces[0];
  }

  private function extractOnuCode()
  {
    $pieces = explode('-', $this->kemlerCode);
    if (count($pieces)==2)
      return $pieces[1];
  }
}
