<?php

class MediaAttachmentParserTSpeed extends AbstractMediaAttachmentParser
{

  public function hasRectangle()
  {
    return (!empty($this->xml->PlateMinX) &&
            !empty($this->xml->PlateMinY) &&
            !empty($this->xml->PlateMaxX) &&
            !empty($this->xml->PlateMaxY));
  }

  public function getRectangle()
  {
    $topLeft = new Coordinate((int) $this->xml->PlateMinX, (int) $this->xml->PlateMinY);
    $bottomRight = new Coordinate((int) $this->xml->PlateMaxX, (int) $this->xml->PlateMaxY);

    $rectangle = new Rectangle($topLeft, $bottomRight);
    return $rectangle;
  }
  
  
  public function getExtraAreas()
  {
  	//var_dump($this->xml);
    $areas = array();

  	if(!empty($this->xml->SubVehiclePlates))
  	{
  		foreach($this->xml->SubVehiclePlates->children() as $area)
  		{
  			$tl = new Coordinate((int)$area->RectMinX, (int)$area->RectMinY);
  			$br = new Coordinate((int)$area->RectMaxX, (int)$area->RectMaxY);
  			$areas['sub_vehicle_plates'][] = new Rectangle($tl, $br);
  		}
  	}
  	if(!empty($this->xml->OtherPlates))
  	{
  		foreach($this->xml->OtherPlates->children() as $area)
  		{
  			$tl = new Coordinate((int)$area->RectMinX, (int)$area->RectMinY);
  			$br = new Coordinate((int)$area->RectMaxX, (int)$area->RectMaxY);
  			$areas['other_plates'][] = new Rectangle($tl, $br);
  		}
  	}
  	
  	if(!empty($this->xml->VehicleDriverFace))
  	{
  		foreach($this->xml->VehicleDriverFace->children() as $area)
  		{
  			$tl = new Coordinate((int)$area->RectMinX, (int)$area->RectMinY);
  			$br = new Coordinate((int)$area->RectMaxX, (int)$area->RectMaxY);
  			$areas['vehicle_driver_face'][] = new Rectangle($tl, $br);
  		}
  	}  	
  	
  	if(!empty($this->xml->AdditionalArea))
  	{
	  	foreach($this->xml->AdditionalArea->children() as $vehicleIDArea)
	  	{
	  		$tl = new Coordinate((int)$vehicleIDArea->RectMinX, (int)$vehicleIDArea->RectMinY);
	  		$br = new Coordinate((int)$vehicleIDArea->RectMaxX, (int)$vehicleIDArea->RectMaxY);
	  		$areas['additional_areas'][] = new Rectangle($tl, $br);
	  	}
  	}
  	
  	if(!empty($this->xml->ExtendedPlateArea))
  	{
  		$tl = new Coordinate((int)$this->xml->ExtendedPlateArea->RectMinX, (int)$this->xml->ExtendedPlateArea->RectMinY);
  		$br = new Coordinate((int)$this->xml->ExtendedPlateArea->RectMaxX, (int)$this->xml->ExtendedPlateArea->RectMaxY);
  		$areas['extended_plate_area'] = new Rectangle($tl, $br);
  	}
  	
  	return $areas;
  }
  
  
}
