<?php
/**
 * @property string vehicle_plate
 * @property string vehicle_model
 * @property string vehicle_nationality
 * @property string vehicle_type
 * @property string owner_name
 * @property string owner_surname
 * @property string owner_email
 * @property string owner_phone
 * @property string owner_address
 * @property string owner_city
 * @property boolean owner_overwrite
 * @property string plateauth_type
 * @property string plateauth_gate
 * @property string plateauth_time
 * @property string validity_startDate
 * @property string validity_startTime
 * @property string validity_endDate
 * @property string validity_endTime
 * @property string other_source
 * @property string other_action
 * @property string other_note
 */
class NewPlateAuthProfileForm extends FormModel
{
  /**
   *
   * @var PlateAuthInsertProfileField[]
   */
  public $fields = array();

  /**
   * attributes defined at runtime
   * @var array
  */
  public $attributesDyn = array();

  /**
   * Declares attribute labels.
  */
  public function myAttributeLabels()
  {
    $labels = array();
    foreach($this->fields as $f)
    if($f instanceof PlateAuthInsertProfileField)
      $labels[$f->name] = t($f->label);
    return $labels;
  }

  /**
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    $rules = array();
    foreach($this->fields as $f)
    if($f instanceof PlateAuthInsertProfileField)
    {
      // if user can insert
      if($f->visible)
      {
        // check required fields
        if($f->required)
        {
          $rules[] = array($f->name,'required');
        }
        // check boolean fields
        if($f->type == PlateAuthInsertProfileFieldType::CHECKBOX)
        {
          $rules[] = array($f->name,'boolean');
        }
        // check dropdown fields
        if($f->type == PlateAuthInsertProfileFieldType::DROPDOWN)
        {
          $rules[] = array($f->name,'rule_value_in_array');
        }
        // check date fields
        if($f->type == PlateAuthInsertProfileFieldType::DATE)
        {
          $rules[] = array($f->name,'date', 'format'=>'d/M/yyyy');
        }
        // check time fields
        if($f->type == PlateAuthInsertProfileFieldType::TIME)
        {
          $rules[] = array($f->name,'date', 'format'=>'H:m');
        }
      }
    }
    $rules[] = array("validity_startDate",'rule_startdatetime_lessoreq_enddatetime');    
    return $rules;
  }

  public function rule_startdatetime_lessoreq_enddatetime($attribute,$params)
  {
    if($this->getStartDateTime()->toDateTime() > $this->getEndDateTime()->toDateTime())
    {
      $this->addError("validity_startDate", t('{attr1} must be less or equal of {attr2}.', array('{attr1}'=>$this->getAttributeLabel('validity_startDate'),'{attr2}'=>$this->getAttributeLabel('validity_endDate'))));
    }
  }

  public function rule_value_in_array($attribute,$params)
  {
    $field = $this->fields[$attribute];
    if(!array_key_exists($this->$attribute,$field->valuesArray))
    {
      $this->addError($attribute, t('{attr} must take one of the specified values.', array('{attr}'=>t($field->label))));
    }
  }

  public function __get($name)
  {
    if(array_key_exists($name, $this->fields))
      return $this->attributesDyn[$name];
    return parent::__get($name);
  }

  public function __set($name, $value)
  {
    if(array_key_exists($name, $this->fields))
      return $this->attributesDyn[$name] = $value;
    return parent::__set($name, $value);
  }

  public function attributeNames()
  {
    return array_keys($this->fields);
  }

  /**
   * @return DateTimeEx
   */
  public function getStartDateTime()
  {
    return DateTimeEx::parse("{$this->validity_startDate} {$this->validity_startTime}:00","d/m/Y H:i:s");
  }

  /**
   * @return DateTimeEx
   */
  public function getEndDateTime()
  {
    return DateTimeEx::parse("{$this->validity_endDate} {$this->validity_endTime}:59","d/m/Y H:i:s");
  }
  
  /**
   *
   * @return string[]
   */
  public function getPlates()
  {
    return plate_list_normalization($this->normalizePlates());
  }

  /**
   * @return string
   */
  public function normalizePlates()
  {
    $this->vehicle_plate = implode(PHP_EOL, plate_list_normalization($this->vehicle_plate,PHP_EOL));
    return $this->vehicle_plate;
  }
  
}
