<?php

/**
 * This is the model class for table "plate_auth_insert_profile".
 *
 * The followings are the available columns in table 'plate_auth_insert_profile':
 * @property integer $id
 * @property string $epoch
 * @property integer $list_code
 * @property string $name
 * @property string $description
 * @property PlateAuthInsertProfileField[] fields
 */
class PlateAuthInsertProfile extends ActiveRecord
{
  /**
   * Returns the static model of the specified AR class.
   * @param string $className active record class name.
   * @return PlateAuthInsertProfile the static model class
   */
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

  /**
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'plate_auth_insert_profile';
  }

  /**
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array(
        array('name, description', 'required'),
        array('list_code', 'numerical', 'integerOnly'=>true),
        array('name, description', 'length', 'max'=>255),
        array('epoch', 'safe'),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array('id, epoch, list_code, name, description', 'safe', 'on'=>'search'),
    );
  }

  /**
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array(
        'fields'=>array(self::HAS_MANY, 'PlateAuthInsertProfileField', 'profile', 'order'=>'fields.order ASC'),
    );
  }

  /**
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array(
        'id' => 'ID',
        'epoch' => t('Epoch'),
        'list_code' => t('List'),
        'name' => t('Name'),
        'description' => t('Button'),
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.

    $criteria=new CDbCriteria;

    $criteria->compare('id',$this->id);
    $criteria->compare('epoch',$this->epoch,true);
    $criteria->compare('list_code',$this->list_code);
    $criteria->compare('name',$this->name,true);
    $criteria->compare('description',$this->description,true);

    return new CActiveDataProvider($this, array(
        'criteria'=>$criteria,
    ));
  }
  
  /**
   * 
   * @return PlateAuthInsertProfileField[]
   */
  public function getNamedField()
  {
    $fields = $this->fields;
    $namedFields = array();
    foreach($fields as $f)
      $namedFields[$f->name] = $f;
    return $namedFields;
  }
}