<?php

/**
 * This is the model class for table "plate_auth_insert_profile_field".
 *
 * The followings are the available columns in table 'plate_auth_insert_profile_field':
 * @property integer $id
 * @property string $epoch
 * @property string $profile
 * @property string $group
 * @property string $name
 * @property string $label
 * @property string $description
 * @property string $type
 * @property boolean $required
 * @property boolean $visible
 * @property boolean $editable
 * @property string $default
 * @property mixed $defaultVar
 * @property string $values
 * @property integer $order
 * @property integer $column
 * @property string[] $valuesArray
 * @property string $comment
 */
class PlateAuthInsertProfileField extends ActiveRecord
{
  /**
   * Returns the static model of the specified AR class.
   * @param string $className active record class name.
   * @return PlateAuthInsertProfileField the static model class
   */
  public static function model($className=__CLASS__)
  {
    return parent::model($className);
  }

  /**
   * @return string the associated database table name
   */
  public function tableName()
  {
    return 'plate_auth_insert_profile_field';
  }

  /**
   * @return array validation rules for model attributes.
   */
  public function rules()
  {
    // NOTE: you should only define rules for those attributes that
    // will receive user inputs.
    return array(
        array('profile, group, name, label, description, type, required, visible, editable, order, column', 'required'),
        array('required, visible, editable, order, column', 'numerical', 'integerOnly'=>true),
        array('profile', 'length', 'max'=>10),
        array('group, name, label, description, type, default, values, comment', 'length', 'max'=>20000),
        array('epoch', 'safe'),
        // The following rule is used by search().
        // Please remove those attributes that should not be searched.
        array('id, epoch, profile, group, name, label, description, type, required, visible, editable, default, values, order, comment, column', 'safe', 'on'=>'search'),
        // custom rules
        array('default', 'rule_check_not_visible_with_default'),
    );
  }
  
  public function getdefaultVar()
  {
    return eval("return {$this->default};");
  }
  
  public function setdefaultVar($value)
  {
    $this->default = _2str($value);
  }
  
  public function rule_check_not_visible_with_default($a,$p)
  {
    if(isEmpty($this->default) && !$this->visible)
    {
      $this->addError('default', t('Not visible fields must have default value set'));
    }
  }

  /**
   * @return array relational rules.
   */
  public function relations()
  {
    // NOTE: you may need to adjust the relation name and the related
    // class name for the relations automatically generated below.
    return array(
        'parent'=>array(self::BELONGS_TO, 'PlateAuthInsertProfile', 'profile'),
    );
  }

  /**
   * @return array customized attribute labels (name=>label)
   */
  public function myAttributeLabels()
  {
    return array(
        'id' => 'ID',
        'epoch' => t('Epoch'),
        'profile' => t('Profile'),
        'group' => t('Group'),
        'name' => t('Name'),
        'label' => t('Label'),
        'description' => t('Description'),
        'type' => t('Type'),
        'required' => t('Required'),
        'visible' => t('Visible'),
        'editable' => t('Editable'),
        'default' => t('Default'),
        'values' => t('Values'),
        'order' => t('Order'),
        'column' => t('Column'),
        'comment' => t('Comment'),
    );
  }

  /**
   * Retrieves a list of models based on the current search/filter conditions.
   * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
   */
  public function search()
  {
    // Warning: Please modify the following code to remove attributes that
    // should not be searched.

    $criteria=new CDbCriteria;

    $criteria->compare('id',$this->id);
    $criteria->compare('epoch',$this->epoch,true);
    $criteria->compare('profile',$this->profile,true);
    $criteria->compare('group',$this->name,true);
    $criteria->compare('name',$this->name,true);
    $criteria->compare('label',$this->label,true);
    $criteria->compare('description',$this->description,true);
    $criteria->compare('type',$this->type,true);
    $criteria->compare('required',$this->required);
    $criteria->compare('visible',$this->visible);
    $criteria->compare('editable',$this->editable);
    $criteria->compare('default',$this->default,true);
    $criteria->compare('values',$this->values,true);
    $criteria->compare('order',$this->order,true);
    $criteria->compare('column',$this->order,true);
    $criteria->compare('comment',$this->comment,true);

    return new CActiveDataProvider($this, array(
        'criteria'=>$criteria,
    ));
  }
  
  public function __get($name)
  {
    if($name == 'valuesArray')
    {
      return array_from_code_to_array($this->values);
    }
    else
    {
      return parent::__get($name);
    }
  }
  
  public function __set($name, $value)
  {
    if($name == 'valuesArray')
    {
      $this->values = array_from_array_to_code($value);
    }
    else
    {
      parent::__set($name,$value);
    }
  }
  
  /**
   * @param PlateAuthInsertProfileField[] $fields by ref
   */
  public static function sort(array &$fields)
  {
    usort($fields, function($x,$y){
      return $x->order < $y->order ? -1 : 1;
    });    
  } 
  
}