<?php

/**
 * This is the model class for table "plate_authorization_action".
 *
 * The followings are the available columns in table 'plate_authorization_action':
 * @property string $id
 * @property string $epoch
 * @property string $id_plate_authorization
 * @property string $id_user
 * @property string $action
 * @property string $note
 * @property string $list_code
 */
class PlateAuthorizationAction extends ActiveRecord
{
	
	const ACTION_ACTIVATED  	='activated';
	const ACTION_DEACTIVATED  	='deactivated';
	const ACTION_CONFIRMED  	='confirmed';
	const ACTION_RENEWED  		='renewed';
	
	
	
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PlateAuthorizationAction the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'plate_authorization_action';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_plate_authorization, id_user', 'required'),
			array('id_plate_authorization, id_user, list_code', 'length', 'max'=>20),
			array('action', 'length', 'max'=>32),
			array('note', 'length', 'max'=>500),
			array('epoch', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, epoch, id_plate_authorization, id_user, action, note, list_code', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'plateAuthorization' => array (
						self::BELONGS_TO,
						'PlateAuthorization',
						'id_plate_authorization'
				),
				'submitted_by' => array (
						self::BELONGS_TO,
						'User',
						'id_user'
				),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'epoch' => 'Epoch',
			'id_plate_authorization' => 'Id Plate Authorization',
			'id_user' => 'Id User',
			'action' => 'Action',
			'note' => 'Note',
			'list_code' => 'List Code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('epoch',$this->epoch,true);
		$criteria->compare('id_plate_authorization',$this->id_plate_authorization,true);
		$criteria->compare('id_user',$this->id_user,true);
		$criteria->compare('action',$this->action,true);
		$criteria->compare('note',$this->note,true);
		$criteria->compare('list_code',$this->list_code,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public function renew()
	{
		$this->action(PlateAuthorizationAction::ACTION_RENEWED);
	}
	public function getSubmitter()
	{
		$smbtid = $this->id_user;
		if ($smbtid === null)
			return t ( 'Unknown' );
		if ($smbtid == 0)
			return t ( 'Event Server' );
		$sbmt = $this->submitted_by;
		if ($sbmt == null)
			return t ( 'Unknown' );
		return $sbmt->getFullName ();
	}
}