<?php

/**
 * This is the model class for table "section_event".
 *
 * The followings are the available columns in table 'section_event':
 * @property string $id
 * @property string $vehicleid
 * @property string $uuid
 * @property string $start_datetime
 * @property string $end_datetime
 * @property string $ref_datetime
 * @property double $ref_offset
 * @property string $ref_timestamp
 * @property double $ref_line_from_pole
 * @property string $status
 * @property string $xml
 * @property string $direction
 * @property double $speed
 * @property string $epoch
 * @property string $image_bw
 * @property string $image_col
 * @property string $id_gate
 */
class SectionEvent extends ActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return SectionEvent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'section_event';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vehicleid, uuid, start_datetime, end_datetime, ref_datetime, ref_offset, ref_timestamp, ref_line_from_pole, status, direction, speed, id_gate', 'required'),
			array('ref_offset, ref_line_from_pole, speed', 'numerical'),
			array('vehicleid, ref_timestamp', 'length', 'max'=>30),
			array('uuid', 'length', 'max'=>40),
			array('status, direction', 'length', 'max'=>10),
			array('image_bw, image_col', 'length', 'max'=>255),
			array('id_gate', 'length', 'max'=>20),
			array('xml, epoch', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, vehicleid, uuid, start_datetime, end_datetime, ref_datetime, ref_offset, ref_timestamp, ref_line_from_pole, status, xml, direction, speed, epoch, image_bw, image_col, id_gate', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function myAttributeLabels()
	{
		return array(
			'id' => 'ID',
			'vehicleid' => t('Plate'),
			'uuid' => 'Uuid',
			'start_datetime' => t('Start Date'),
			'end_datetime' => t('End Time'),
			'ref_datetime' => t('Reference Datetime'),
			'ref_offset' => t('Reference Offset'),
			'ref_timestamp' => t('Reference Timestamp'),
			'ref_line_from_pole' => t('Reference Line From Pole'),
			'status' => t('Status'),
			'xml' => 'Xml',
			'direction' => t('Direction'),
			'speed' => t('Speed'),
			'epoch' => t('Epoch'),
			'image_bw' => t('Image'),
			'image_col' => t('Context Image'),
			'id_gate' => t('Gate'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('vehicleid',$this->vehicleid,true);
		$criteria->compare('uuid',$this->uuid,true);
		$criteria->compare('start_datetime',$this->start_datetime,true);
		$criteria->compare('end_datetime',$this->end_datetime,true);
		$criteria->compare('ref_datetime',$this->ref_datetime,true);
		$criteria->compare('ref_offset',$this->ref_offset);
		$criteria->compare('ref_timestamp',$this->ref_timestamp,true);
		$criteria->compare('ref_line_from_pole',$this->ref_line_from_pole);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('xml',$this->xml,true);
		$criteria->compare('direction',$this->direction,true);
		$criteria->compare('speed',$this->speed);
		$criteria->compare('epoch',$this->epoch,true);
		$criteria->compare('image_bw',$this->image_bw,true);
		$criteria->compare('image_col',$this->image_col,true);
		$criteria->compare('id_gate',$this->id_gate,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}